/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.Properties;
import org.duckdb.DuckDBConnection;
import org.duckdb.DuckDBResultSetMetaData;
import org.duckdb.DuckDBVector;

class DuckDBNative {
    DuckDBNative() {
    }

    protected static native ByteBuffer duckdb_jdbc_startup(byte[] var0, boolean var1, Properties var2) throws SQLException;

    protected static native ByteBuffer duckdb_jdbc_connect(ByteBuffer var0) throws SQLException;

    protected static native void duckdb_jdbc_set_auto_commit(ByteBuffer var0, boolean var1) throws SQLException;

    protected static native boolean duckdb_jdbc_get_auto_commit(ByteBuffer var0) throws SQLException;

    protected static native void duckdb_jdbc_disconnect(ByteBuffer var0);

    protected static native void duckdb_jdbc_set_schema(ByteBuffer var0, String var1);

    protected static native void duckdb_jdbc_set_catalog(ByteBuffer var0, String var1);

    protected static native String duckdb_jdbc_get_schema(ByteBuffer var0);

    protected static native String duckdb_jdbc_get_catalog(ByteBuffer var0);

    protected static native ByteBuffer duckdb_jdbc_prepare(ByteBuffer var0, byte[] var1) throws SQLException;

    protected static native void duckdb_jdbc_release(ByteBuffer var0);

    protected static native DuckDBResultSetMetaData duckdb_jdbc_query_result_meta(ByteBuffer var0) throws SQLException;

    protected static native DuckDBResultSetMetaData duckdb_jdbc_prepared_statement_meta(ByteBuffer var0) throws SQLException;

    protected static native ByteBuffer duckdb_jdbc_execute(ByteBuffer var0, Object[] var1) throws SQLException;

    protected static native void duckdb_jdbc_free_result(ByteBuffer var0);

    protected static native DuckDBVector[] duckdb_jdbc_fetch(ByteBuffer var0, ByteBuffer var1) throws SQLException;

    protected static native int duckdb_jdbc_fetch_size();

    protected static native long duckdb_jdbc_arrow_stream(ByteBuffer var0, long var1);

    protected static native void duckdb_jdbc_arrow_register(ByteBuffer var0, long var1, byte[] var3);

    protected static native ByteBuffer duckdb_jdbc_create_appender(ByteBuffer var0, byte[] var1, byte[] var2) throws SQLException;

    protected static native void duckdb_jdbc_appender_begin_row(ByteBuffer var0) throws SQLException;

    protected static native void duckdb_jdbc_appender_end_row(ByteBuffer var0) throws SQLException;

    protected static native void duckdb_jdbc_appender_flush(ByteBuffer var0) throws SQLException;

    protected static native void duckdb_jdbc_interrupt(ByteBuffer var0);

    protected static native void duckdb_jdbc_appender_close(ByteBuffer var0) throws SQLException;

    protected static native void duckdb_jdbc_appender_append_boolean(ByteBuffer var0, boolean var1) throws SQLException;

    protected static native void duckdb_jdbc_appender_append_byte(ByteBuffer var0, byte var1) throws SQLException;

    protected static native void duckdb_jdbc_appender_append_short(ByteBuffer var0, short var1) throws SQLException;

    protected static native void duckdb_jdbc_appender_append_int(ByteBuffer var0, int var1) throws SQLException;

    protected static native void duckdb_jdbc_appender_append_long(ByteBuffer var0, long var1) throws SQLException;

    protected static native void duckdb_jdbc_appender_append_float(ByteBuffer var0, float var1) throws SQLException;

    protected static native void duckdb_jdbc_appender_append_double(ByteBuffer var0, double var1) throws SQLException;

    protected static native void duckdb_jdbc_appender_append_string(ByteBuffer var0, byte[] var1) throws SQLException;

    protected static native void duckdb_jdbc_appender_append_bytes(ByteBuffer var0, byte[] var1) throws SQLException;

    protected static native void duckdb_jdbc_appender_append_timestamp(ByteBuffer var0, long var1) throws SQLException;

    protected static native void duckdb_jdbc_appender_append_decimal(ByteBuffer var0, BigDecimal var1) throws SQLException;

    protected static native void duckdb_jdbc_appender_append_null(ByteBuffer var0) throws SQLException;

    protected static native void duckdb_jdbc_create_extension_type(ByteBuffer var0) throws SQLException;

    public static void duckdb_jdbc_create_extension_type(DuckDBConnection conn) throws SQLException {
        DuckDBNative.duckdb_jdbc_create_extension_type(conn.conn_ref);
    }

    static {
        block32: {
            try {
                String os_arch;
                String os_arch_detect;
                String os_name = "";
                String os_name_detect = System.getProperty("os.name").toLowerCase().trim();
                switch (os_arch_detect = System.getProperty("os.arch").toLowerCase().trim()) {
                    case "x86_64": 
                    case "amd64": {
                        os_arch = "amd64";
                        break;
                    }
                    case "aarch64": 
                    case "arm64": {
                        os_arch = "arm64";
                        break;
                    }
                    case "i386": {
                        os_arch = "i386";
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported system architecture");
                    }
                }
                if (os_name_detect.startsWith("windows")) {
                    os_name = "windows";
                } else if (os_name_detect.startsWith("mac")) {
                    os_name = "osx";
                    os_arch = "universal";
                } else if (os_name_detect.startsWith("linux")) {
                    os_name = "linux";
                }
                String lib_res_name = "/libduckdb_java.so_" + os_name + "_" + os_arch;
                Path lib_file = Files.createTempFile("libduckdb_java", ".so", new FileAttribute[0]);
                URL lib_res = DuckDBNative.class.getResource(lib_res_name);
                if (lib_res == null) {
                    System.load(Paths.get("build/debug", lib_res_name).normalize().toAbsolutePath().toString());
                    break block32;
                }
                try (InputStream lib_res_input_stream = lib_res.openStream();){
                    Files.copy(lib_res_input_stream, lib_file, StandardCopyOption.REPLACE_EXISTING);
                }
                new File(lib_file.toString()).deleteOnExit();
                System.load(lib_file.toAbsolutePath().toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

