/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import org.duckdb.DuckDBDate;
import org.duckdb.DuckDBTime;
import org.duckdb.DuckDBTimestampTZ;

public class DuckDBTimestamp {
    static final LocalDateTime RefLocalDateTime = LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC);
    protected long timeMicros;

    public DuckDBTimestamp(long timeMicros) {
        this.timeMicros = timeMicros;
    }

    public DuckDBTimestamp(LocalDateTime localDateTime) {
        this.timeMicros = DuckDBTimestamp.localDateTime2Micros(localDateTime);
    }

    public DuckDBTimestamp(OffsetDateTime offsetDateTime) {
        this.timeMicros = RefLocalDateTime.until(offsetDateTime.withOffsetSameInstant(ZoneOffset.UTC), ChronoUnit.MICROS);
    }

    public DuckDBTimestamp(Timestamp sqlTimestamp) {
        this.timeMicros = RefLocalDateTime.until(sqlTimestamp.toLocalDateTime(), ChronoUnit.MICROS);
    }

    private static Instant createInstant(long value, ChronoUnit unit) throws SQLException {
        switch (unit) {
            case SECONDS: {
                return Instant.ofEpochSecond(value);
            }
            case MILLIS: {
                return Instant.ofEpochMilli(value);
            }
            case MICROS: {
                long epochSecond = value / 1000000L;
                int nanoAdjustment = DuckDBTimestamp.nanosPartMicros(value);
                return Instant.ofEpochSecond(epochSecond, nanoAdjustment);
            }
            case NANOS: {
                long epochSecond = value / 1000000000L;
                long nanoAdjustment = DuckDBTimestamp.nanosPartNanos(value);
                return Instant.ofEpochSecond(epochSecond, nanoAdjustment);
            }
        }
        throw new SQLException("Unsupported unit type: [" + unit + "]");
    }

    public static LocalDateTime localDateTimeFromTimestampWithTimezone(long value, ChronoUnit unit, ZoneId zoneIdNullable) throws SQLException {
        Instant instant = DuckDBTimestamp.createInstant(value, unit);
        ZoneId zoneId = zoneIdNullable != null ? zoneIdNullable : ZoneId.systemDefault();
        return LocalDateTime.ofInstant(instant, zoneId);
    }

    public static LocalDateTime localDateTimeFromTimestamp(long value, ChronoUnit unit, ZoneId zoneIdNullable) throws SQLException {
        Instant instant = DuckDBTimestamp.createInstant(value, unit);
        LocalDateTime ldt = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        if (null == zoneIdNullable) {
            return ldt;
        }
        ZoneId zoneIdDefault = ZoneId.systemDefault();
        LocalDateTime ldtDefault = LocalDateTime.ofInstant(instant, zoneIdDefault);
        LocalDateTime ldtZoned = LocalDateTime.ofInstant(instant, zoneIdNullable);
        Duration duration = Duration.between(ldtZoned, ldtDefault);
        LocalDateTime ldtAdjusted = ldt.plus(duration);
        return ldtAdjusted;
    }

    public static OffsetTime toOffsetTime(long timeBits) {
        long timeMicros = timeBits >> 24;
        long offset = timeBits & 0xFFFFFFL;
        long max_offset = 57599L;
        int sign = (offset = max_offset - offset) < 0L ? -1 : 1;
        offset = Math.abs(offset);
        int ss = (int)offset % 60;
        int mm = (int)(offset /= 60L) % 60;
        int hh = (int)offset / 60;
        if (hh > 15) {
            return OffsetTime.of(DuckDBTimestamp.toLocalTime(timeMicros), ZoneOffset.UTC);
        }
        return OffsetTime.of(DuckDBTimestamp.toLocalTime(timeMicros), ZoneOffset.ofHoursMinutesSeconds(sign * hh, sign * mm, sign * ss));
    }

    private static LocalTime toLocalTime(long timeMicros) {
        return LocalTime.ofNanoOfDay(timeMicros * 1000L);
    }

    public static long localDateTime2Micros(LocalDateTime localDateTime) {
        return RefLocalDateTime.until(localDateTime, ChronoUnit.MICROS);
    }

    public static Object valueOf(Object x) {
        if (x instanceof Timestamp) {
            x = new DuckDBTimestamp((Timestamp)x);
        } else if (x instanceof LocalDateTime) {
            x = new DuckDBTimestamp((LocalDateTime)x);
        } else if (x instanceof LocalDate) {
            x = new DuckDBDate(Date.valueOf((LocalDate)x));
        } else if (x instanceof OffsetDateTime) {
            x = new DuckDBTimestampTZ((OffsetDateTime)x);
        } else if (x instanceof Date) {
            x = new DuckDBDate((Date)x);
        } else if (x instanceof Time) {
            x = new DuckDBTime((Time)x);
        }
        return x;
    }

    public Timestamp toSqlTimestamp() {
        return Timestamp.valueOf(this.toLocalDateTime());
    }

    public LocalDateTime toLocalDateTime() {
        return LocalDateTime.ofEpochSecond(DuckDBTimestamp.micros2seconds(this.timeMicros), DuckDBTimestamp.nanosPartMicros(this.timeMicros), ZoneOffset.UTC);
    }

    public OffsetDateTime toOffsetDateTime() {
        return OffsetDateTime.of(this.toLocalDateTime(), ZoneOffset.UTC);
    }

    public static long getMicroseconds(Timestamp sqlTimestamp) {
        return RefLocalDateTime.until(sqlTimestamp.toLocalDateTime(), ChronoUnit.MICROS);
    }

    public long getMicrosEpoch() {
        return this.timeMicros;
    }

    public String toString() {
        return this.toLocalDateTime().toString();
    }

    private static long micros2seconds(long micros) {
        if (micros % 1000000L >= 0L) {
            return micros / 1000000L;
        }
        return micros / 1000000L - 1L;
    }

    private static int nanosPartMicros(long micros) {
        if (micros % 1000000L >= 0L) {
            return (int)(micros % 1000000L * 1000L);
        }
        return (int)((1000000L + micros % 1000000L) * 1000L);
    }

    private static long nanos2seconds(long nanos) {
        if (nanos % 1000000000L >= 0L) {
            return nanos / 1000000000L;
        }
        return nanos / 1000000000L - 1L;
    }

    private static int nanosPartNanos(long nanos) {
        if (nanos % 1000000000L >= 0L) {
            return (int)(nanos % 1000000000L);
        }
        return (int)(1000000000L + nanos % 1000000000L);
    }
}

