/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.sql.SQLException;
import java.util.Properties;

final class JdbcUtils {
    private JdbcUtils() {
    }

    static <T> T unwrap(Object obj, Class<T> iface) throws SQLException {
        if (!iface.isInstance(obj)) {
            throw new SQLException(obj.getClass().getName() + " not unwrappable from " + iface.getName());
        }
        return (T)obj;
    }

    static String removeOption(Properties props, String opt) {
        return JdbcUtils.removeOption(props, opt, null);
    }

    static String removeOption(Properties props, String opt, String defaultVal) {
        Object obj = props.remove(opt);
        if (null != obj) {
            return obj.toString().trim();
        }
        return defaultVal;
    }

    static void setDefaultOptionValue(Properties props, String opt, Object value) {
        if (props.contains(opt)) {
            return;
        }
        props.put(opt, value);
    }

    static boolean isStringTruish(String val, boolean defaultVal) throws SQLException {
        if (null == val) {
            return defaultVal;
        }
        String valLower = val.toLowerCase().trim();
        if (valLower.equals("true") || valLower.equals("1") || valLower.equals("yes") || valLower.equals("on")) {
            return true;
        }
        if (valLower.equals("false") || valLower.equals("0") || valLower.equals("no") || valLower.equals("off")) {
            return false;
        }
        throw new SQLException("Invalid boolean option value: " + val);
    }

    static String dbNameFromUrl(String url) throws SQLException {
        String shortUrl;
        if (null == url) {
            throw new SQLException("Invalid null URL specified");
        }
        if (!url.startsWith("jdbc:duckdb:")) {
            throw new SQLException("DuckDB JDBC URL needs to start with 'jdbc:duckdb:'");
        }
        if (url.contains(";")) {
            String[] parts = url.split(";");
            shortUrl = parts[0].trim();
        } else {
            shortUrl = url;
        }
        String dbName = shortUrl.substring("jdbc:duckdb:".length()).trim();
        if (dbName.length() == 0) {
            dbName = ":memory:";
        }
        if (dbName.startsWith(":memory:".substring(1))) {
            dbName = ":" + dbName;
        }
        return dbName;
    }

    static String bytesToHex(byte[] bytes) {
        if (null == bytes) {
            return "";
        }
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    static void closeQuietly(AutoCloseable closeable) {
        if (null == closeable) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

