/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.test;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.duracloud.common.json.JaxbJsonSerializer;
import org.duracloud.common.model.SimpleCredential;
import org.duracloud.common.test.StorageProviderCredential;
import org.duracloud.common.test.TestConfig;

public class TestConfigUtil {
    public static final String DURACLOUD_TEST_CONFIG = "DURACLOUD_TEST_CONFIG";

    public TestConfig getTestConfig() throws IOException {
        String testConfigPath = System.getenv().get(DURACLOUD_TEST_CONFIG);
        if (null == testConfigPath || testConfigPath.isEmpty()) {
            throw new RuntimeException("In order to run integration tests, an environment variable named DURACLOUD_TEST_CONFIG must be supplied.");
        }
        File configFile = new File(testConfigPath);
        if (!configFile.exists()) {
            throw new RuntimeException("No integration test configuration file could be found at path " + testConfigPath);
        }
        String jsonTestConfig = FileUtils.readFileToString((File)configFile);
        JaxbJsonSerializer<TestConfig> serializer = new JaxbJsonSerializer<TestConfig>(TestConfig.class);
        return serializer.deserialize(jsonTestConfig);
    }

    public SimpleCredential getCredential(StorageProviderCredential.ProviderType type) throws IOException {
        TestConfig config = this.getTestConfig();
        for (StorageProviderCredential cred : config.getProviderCredentials()) {
            if (!cred.getType().equals((Object)type)) continue;
            return cred.getCredential();
        }
        throw new IOException("No credential available for type: " + type.name());
    }

    public String getSwiftEndpoint() throws IOException {
        TestConfig config = this.getTestConfig();
        return config.getSwiftEndpoint();
    }

    public String getSwiftSignerType() throws IOException {
        TestConfig config = this.getTestConfig();
        return config.getSwiftSignerType();
    }
}

