/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.util.metrics;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Formatter;
import java.util.Iterator;
import org.duracloud.common.util.metrics.Metric;
import org.duracloud.common.util.metrics.MetricException;
import org.duracloud.common.util.metrics.MetricsTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsReport {
    protected final Logger log = LoggerFactory.getLogger(MetricsReport.class);
    private final String title;
    private final BufferedWriter writer;
    private final Formatter formatter;
    private final int LINE_WIDTH = 80;
    final int LEVEL_0 = 0;

    public MetricsReport(String title, String metricsFileName) throws IOException {
        this.title = title;
        this.writer = new BufferedWriter(new FileWriter(new File(metricsFileName)));
        this.formatter = new Formatter(this.writer);
    }

    public void writeReport(MetricsTable table) {
        this.writeProlog();
        this.writeMetrics(table, 0);
        this.formatter.flush();
        this.formatter.close();
    }

    private void writeMetrics(MetricsTable table, int level) {
        Iterator<Metric> metrics = table.getMetrics();
        while (metrics.hasNext()) {
            Metric parent = metrics.next();
            this.writeMetricHeader(parent, level);
            Iterator<Metric.MetricElement> elems = parent.getElements();
            while (elems.hasNext()) {
                Metric.MetricElement elem = elems.next();
                this.writeMetricElement(elem, level + 1);
                try {
                    this.writeMetrics(table.getSubTable(parent, elem), level + 1);
                }
                catch (MetricException e) {
                    this.log.debug("Error writing metrics", (Throwable)e);
                }
            }
            this.separator('-');
        }
    }

    private void writeProlog() {
        this.separator('=');
        String text = "Test metrics for: " + this.title;
        this.formatter.format("%s", text);
        int width = this.LINE_WIDTH - text.length();
        this.formatter.format("%1$" + width + "tc%n", new Date());
        this.separator('=');
    }

    private void writeMetricHeader(Metric metric, int level) {
        if (level == 0) {
            String text = "Measuring: " + metric.getHeader();
            this.formatter.format("%n%n%s", text);
            int width = this.LINE_WIDTH - text.length();
            this.formatter.format("%1$" + width + "s%n", "elapsed secs");
        }
        this.separator('-');
    }

    private void writeMetricElement(Metric.MetricElement elem, int level) {
        String text = this.prefix('.', level) + elem.getSubHeader();
        this.formatter.format("%1$s", text);
        int width = this.LINE_WIDTH - text.length();
        this.formatter.format("%1$" + width + ".3f%n", Float.valueOf(elem.elapsedSecs()));
    }

    private void separator(char c) {
        StringBuffer sep = new StringBuffer();
        for (int i = 0; i < 80; ++i) {
            sep.append(c);
        }
        this.formatter.format("%s%n", sep);
    }

    private String prefix(char c, int times) {
        StringBuffer pre = new StringBuffer();
        for (int i = 0; i < times * 2; ++i) {
            pre.append(c);
        }
        return pre.toString();
    }
}

