/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.storage.domain;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.duracloud.storage.domain.StorageAccount;
import org.duracloud.storage.error.StorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageAccountManager {
    protected final Logger log = LoggerFactory.getLogger(StorageAccountManager.class);
    private String primaryStorageProviderId = null;
    private HashMap<String, StorageAccount> storageAccounts = null;
    private String instanceHost;
    private String instancePort;
    private String accountName;

    public void initialize(List<StorageAccount> accts) throws StorageException {
        this.storageAccounts = new HashMap();
        for (StorageAccount acct : accts) {
            this.storageAccounts.put(acct.getId(), acct);
            if (!acct.isPrimary()) continue;
            this.primaryStorageProviderId = acct.getId();
        }
        if (this.primaryStorageProviderId == null) {
            this.primaryStorageProviderId = accts.get(0).getId();
        }
    }

    public void setEnvironment(String instanceHost, String instancePort, String accountName) {
        this.instanceHost = instanceHost;
        this.instancePort = instancePort;
        this.accountName = accountName;
    }

    public String getInstanceHost() {
        return this.instanceHost;
    }

    public String getInstancePort() {
        return this.instancePort;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public StorageAccount getPrimaryStorageAccount() {
        this.checkInitialized();
        return this.getStorageAccount(this.primaryStorageProviderId);
    }

    public Iterator<String> getStorageAccountIds() {
        this.checkInitialized();
        return this.storageAccounts.keySet().iterator();
    }

    public StorageAccount getStorageAccount(String storageProviderId) {
        this.checkInitialized();
        return this.storageAccounts.get(storageProviderId);
    }

    public Map<String, StorageAccount> getStorageAccounts() {
        this.checkInitialized();
        return this.storageAccounts;
    }

    private void checkInitialized() throws StorageException {
        if (!this.isInitialized()) {
            String error = "DuraStore's StorageAccountManager must be initialized with an XML file containing storage account information before any further requests can be fulfilled.";
            throw new StorageException(error);
        }
    }

    public boolean isInitialized() throws StorageException {
        return null != this.storageAccounts && null != this.primaryStorageProviderId;
    }
}

