/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.storage.xml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.storage.domain.StorageAccount;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.xml.StorageAccountProviderBinding;
import org.duracloud.storage.xml.impl.StorageAccountProviderSimpleBindingImpl;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageAccountsDocumentBinding {
    private final Logger log = LoggerFactory.getLogger(StorageAccountsDocumentBinding.class);
    private Map<StorageProviderType, StorageAccountProviderBinding> providerBindings = new HashMap<StorageProviderType, StorageAccountProviderBinding>();

    public StorageAccountsDocumentBinding() {
        for (StorageProviderType type : StorageProviderType.values()) {
            StorageAccountProviderSimpleBindingImpl binding = new StorageAccountProviderSimpleBindingImpl();
            this.providerBindings.put(type, binding);
        }
    }

    public List<StorageAccount> createStorageAccountsFrom(Element accounts) {
        ArrayList<StorageAccount> accts = new ArrayList<StorageAccount>();
        try {
            for (Element accountXml : accounts.getChildren()) {
                String type = accountXml.getChildText("storageProviderType");
                StorageProviderType acctType = StorageProviderType.fromString((String)type);
                StorageAccountProviderBinding providerBinding = this.providerBindings.get(acctType);
                if (null != providerBinding) {
                    accts.add(providerBinding.getAccountFromXml(accountXml));
                    continue;
                }
                this.log.warn("Unexpected account type: " + acctType);
            }
            if (accts.isEmpty()) {
                String error = "No storage accounts could be read";
                throw new StorageException(error);
            }
        }
        catch (Exception e) {
            String error = "Unable to build storage account information due to error: " + e.getMessage();
            this.log.error(error);
            throw new StorageException(error, e);
        }
        return accts;
    }

    public List<StorageAccount> createStorageAccountsFromXml(InputStream xml) {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(xml);
            Element root = doc.getRootElement();
            return this.createStorageAccountsFrom(root);
        }
        catch (Exception e) {
            String error = "Could not build storage accounts from xml due to: " + e.getMessage();
            throw new DuraCloudRuntimeException(error, (Throwable)e);
        }
    }

    public Element createDocumentFrom(Collection<StorageAccount> accts, boolean includeCredentials, boolean includeOptions) {
        Element storageProviderAccounts = new Element("storageProviderAccounts");
        if (null != accts && accts.size() > 0) {
            for (StorageAccount acct : accts) {
                StorageAccountProviderBinding providerBinding = this.providerBindings.get(acct.getType());
                if (null != providerBinding) {
                    storageProviderAccounts.addContent((Content)providerBinding.getElementFrom(acct, includeCredentials, includeOptions));
                    continue;
                }
                this.log.warn("Unexpected account type: " + acct.getType());
            }
        }
        return storageProviderAccounts;
    }

    public String createXmlFrom(Collection<StorageAccount> accts, boolean includeCredentials, boolean includeOptions) {
        Element storageProviderAccounts = this.createDocumentFrom(accts, includeCredentials, includeOptions);
        Document document = new Document(storageProviderAccounts);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        return outputter.outputString(document);
    }
}

