/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.client.task;

import org.duracloud.client.ContentStore;
import org.duracloud.client.task.SnapshotTaskClient;
import org.duracloud.error.ContentStoreException;
import org.duracloud.snapshot.dto.SnapshotStatus;
import org.duracloud.snapshot.dto.task.CleanupSnapshotTaskParameters;
import org.duracloud.snapshot.dto.task.CleanupSnapshotTaskResult;
import org.duracloud.snapshot.dto.task.CompleteRestoreTaskParameters;
import org.duracloud.snapshot.dto.task.CompleteRestoreTaskResult;
import org.duracloud.snapshot.dto.task.CompleteSnapshotTaskParameters;
import org.duracloud.snapshot.dto.task.CompleteSnapshotTaskResult;
import org.duracloud.snapshot.dto.task.CreateSnapshotTaskParameters;
import org.duracloud.snapshot.dto.task.CreateSnapshotTaskResult;
import org.duracloud.snapshot.dto.task.GetRestoreTaskParameters;
import org.duracloud.snapshot.dto.task.GetRestoreTaskResult;
import org.duracloud.snapshot.dto.task.GetSnapshotContentsTaskParameters;
import org.duracloud.snapshot.dto.task.GetSnapshotContentsTaskResult;
import org.duracloud.snapshot.dto.task.GetSnapshotHistoryTaskParameters;
import org.duracloud.snapshot.dto.task.GetSnapshotHistoryTaskResult;
import org.duracloud.snapshot.dto.task.GetSnapshotListTaskResult;
import org.duracloud.snapshot.dto.task.GetSnapshotTaskParameters;
import org.duracloud.snapshot.dto.task.GetSnapshotTaskResult;
import org.duracloud.snapshot.dto.task.GetSnapshotsTotalsTaskParameters;
import org.duracloud.snapshot.dto.task.GetSnapshotsTotalsTaskResult;
import org.duracloud.snapshot.dto.task.RequestRestoreSnapshotTaskResult;
import org.duracloud.snapshot.dto.task.RestoreSnapshotTaskParameters;
import org.duracloud.snapshot.dto.task.RestoreSnapshotTaskResult;

public class SnapshotTaskClientImpl
implements SnapshotTaskClient {
    private ContentStore contentStore;

    public SnapshotTaskClientImpl(ContentStore contentStore) {
        this.contentStore = contentStore;
    }

    @Override
    public CreateSnapshotTaskResult createSnapshot(String spaceId, String description, String userEmail) throws ContentStoreException {
        CreateSnapshotTaskParameters taskParams = new CreateSnapshotTaskParameters();
        taskParams.setSpaceId(spaceId);
        taskParams.setDescription(description);
        taskParams.setUserEmail(userEmail);
        String taskResult = this.contentStore.performTaskWithNoRetries("create-snapshot", taskParams.serialize());
        return CreateSnapshotTaskResult.deserialize((String)taskResult);
    }

    @Override
    public GetSnapshotTaskResult getSnapshot(String snapshotId) throws ContentStoreException {
        GetSnapshotTaskParameters taskParams = new GetSnapshotTaskParameters();
        taskParams.setSnapshotId(snapshotId);
        String taskResult = this.contentStore.performTask("get-snapshot", taskParams.serialize());
        return GetSnapshotTaskResult.deserialize((String)taskResult);
    }

    @Override
    public CleanupSnapshotTaskResult cleanupSnapshot(String spaceId) throws ContentStoreException {
        CleanupSnapshotTaskParameters taskParams = new CleanupSnapshotTaskParameters();
        taskParams.setSpaceId(spaceId);
        String taskResult = this.contentStore.performTask("cleanup-snapshot", taskParams.serialize());
        return CleanupSnapshotTaskResult.deserialize((String)taskResult);
    }

    @Override
    public CompleteSnapshotTaskResult completeSnapshot(String spaceId) throws ContentStoreException {
        CompleteSnapshotTaskParameters taskParams = new CompleteSnapshotTaskParameters();
        taskParams.setSpaceId(spaceId);
        String taskResult = this.contentStore.performTask("complete-snapshot", taskParams.serialize());
        return CompleteSnapshotTaskResult.deserialize((String)taskResult);
    }

    @Override
    public GetSnapshotListTaskResult getSnapshots() throws ContentStoreException {
        String taskResult = this.contentStore.performTask("get-snapshots", "");
        return GetSnapshotListTaskResult.deserialize((String)taskResult);
    }

    @Override
    public GetSnapshotsTotalsTaskResult getSnapshotsTotals(String status) throws ContentStoreException {
        if (null == status) {
            status = SnapshotStatus.SNAPSHOT_COMPLETE.name();
        }
        GetSnapshotsTotalsTaskParameters taskParams = new GetSnapshotsTotalsTaskParameters();
        taskParams.setStatus(status);
        String taskResult = this.contentStore.performTask("get-snapshots-totals", taskParams.serialize());
        return GetSnapshotsTotalsTaskResult.deserialize((String)taskResult);
    }

    @Override
    public GetSnapshotContentsTaskResult getSnapshotContents(String snapshotId, int pageNumber, int pageSize, String prefix) throws ContentStoreException {
        GetSnapshotContentsTaskParameters taskParams = new GetSnapshotContentsTaskParameters();
        taskParams.setSnapshotId(snapshotId);
        taskParams.setPageNumber(pageNumber);
        taskParams.setPageSize(pageSize);
        taskParams.setPrefix(prefix);
        String taskResult = this.contentStore.performTask("get-snapshot-contents", taskParams.serialize());
        return GetSnapshotContentsTaskResult.deserialize((String)taskResult);
    }

    @Override
    public GetSnapshotHistoryTaskResult getSnapshotHistory(String snapshotId, int pageNumber, int pageSize) throws ContentStoreException {
        GetSnapshotHistoryTaskParameters taskParams = new GetSnapshotHistoryTaskParameters();
        taskParams.setSnapshotId(snapshotId);
        taskParams.setPageNumber(pageNumber);
        taskParams.setPageSize(pageSize);
        String taskResult = this.contentStore.performTask("get-snapshot-history", taskParams.serialize());
        return GetSnapshotHistoryTaskResult.deserialize((String)taskResult);
    }

    @Override
    public RestoreSnapshotTaskResult restoreSnapshot(String snapshotId, String userEmail) throws ContentStoreException {
        RestoreSnapshotTaskParameters taskParams = new RestoreSnapshotTaskParameters();
        taskParams.setSnapshotId(snapshotId);
        taskParams.setUserEmail(userEmail);
        String taskResult = this.contentStore.performTaskWithNoRetries("restore-snapshot", taskParams.serialize());
        return RestoreSnapshotTaskResult.deserialize((String)taskResult);
    }

    @Override
    public RequestRestoreSnapshotTaskResult requestRestoreSnapshot(String snapshotId, String userEmail) throws ContentStoreException {
        RestoreSnapshotTaskParameters taskParams = new RestoreSnapshotTaskParameters();
        taskParams.setSnapshotId(snapshotId);
        taskParams.setUserEmail(userEmail);
        String taskResult = this.contentStore.performTask("request-restore-snapshot", taskParams.serialize());
        return RequestRestoreSnapshotTaskResult.deserialize((String)taskResult);
    }

    @Override
    public CompleteRestoreTaskResult completeRestore(String spaceId, int daysToExpire) throws ContentStoreException {
        CompleteRestoreTaskParameters taskParams = new CompleteRestoreTaskParameters();
        taskParams.setSpaceId(spaceId);
        taskParams.setDaysToExpire(daysToExpire);
        String taskResult = this.contentStore.performTask("complete-restore", taskParams.serialize());
        return CompleteRestoreTaskResult.deserialize((String)taskResult);
    }

    @Override
    public GetRestoreTaskResult getRestore(String restoreId) throws ContentStoreException {
        GetRestoreTaskParameters taskParams = new GetRestoreTaskParameters();
        taskParams.setRestoreId(restoreId);
        String taskResult = this.contentStore.performTask("get-restore", taskParams.serialize());
        return GetRestoreTaskResult.deserialize((String)taskResult);
    }

    @Override
    public GetRestoreTaskResult getRestoreBySnapshot(String snapshotId) throws ContentStoreException {
        GetRestoreTaskParameters taskParams = new GetRestoreTaskParameters();
        taskParams.setSnapshotId(snapshotId);
        String taskResult = this.contentStore.performTask("get-restore", taskParams.serialize());
        return GetRestoreTaskResult.deserialize((String)taskResult);
    }
}

