/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.dynalink.beans;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;

public class CallerSensitiveDetector {
    private static final String CALLER_SENSITIVE_CLASS_NAME = "sun.reflect.CallerSensitive";
    private static final DetectionStrategy DETECTION_STRATEGY = CallerSensitiveDetector.getDetectionStrategy();

    static boolean isCallerSensitive(AccessibleObject ao) {
        return DETECTION_STRATEGY.isCallerSensitive(ao);
    }

    private static DetectionStrategy getDetectionStrategy() {
        try {
            return new PrivilegedDetectionStrategy();
        }
        catch (Throwable t) {
            return new UnprivilegedDetectionStrategy();
        }
    }

    static class UnprivilegedDetectionStrategy
    extends DetectionStrategy {
        private static final String CALLER_SENSITIVE_ANNOTATION_STRING = "@sun.reflect.CallerSensitive()";

        UnprivilegedDetectionStrategy() {
        }

        @Override
        boolean isCallerSensitive(AccessibleObject o) {
            for (Annotation a : o.getAnnotations()) {
                if (!String.valueOf(a).equals(CALLER_SENSITIVE_ANNOTATION_STRING)) continue;
                return true;
            }
            return false;
        }
    }

    static class PrivilegedDetectionStrategy
    extends DetectionStrategy {
        private static final Class<? extends Annotation> CALLER_SENSITIVE_ANNOTATION_CLASS = PrivilegedDetectionStrategy.getCallerSensitiveClass();

        PrivilegedDetectionStrategy() {
        }

        private static Class<? extends Annotation> getCallerSensitiveClass() {
            try {
                return Class.forName(CallerSensitiveDetector.CALLER_SENSITIVE_CLASS_NAME);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        boolean isCallerSensitive(AccessibleObject ao) {
            return ao.getAnnotation(CALLER_SENSITIVE_ANNOTATION_CLASS) != null;
        }
    }

    static abstract class DetectionStrategy {
        DetectionStrategy() {
        }

        abstract boolean isCallerSensitive(AccessibleObject var1);
    }
}

