/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.dynalink.beans;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import org.dynalang.dynalink.CallSiteDescriptor;
import org.dynalang.dynalink.beans.DynamicMethod;
import org.dynalang.dynalink.linker.GuardedInvocation;
import org.dynalang.dynalink.linker.LinkRequest;
import org.dynalang.dynalink.linker.LinkerServices;
import org.dynalang.dynalink.linker.TypeBasedGuardingDynamicLinker;
import org.dynalang.dynalink.support.CallSiteDescriptorFactory;
import org.dynalang.dynalink.support.Guards;

class DynamicMethodLinker
implements TypeBasedGuardingDynamicLinker {
    DynamicMethodLinker() {
    }

    @Override
    public boolean canLinkType(Class<?> type) {
        return DynamicMethod.class.isAssignableFrom(type);
    }

    @Override
    public GuardedInvocation getGuardedInvocation(LinkRequest linkRequest, LinkerServices linkerServices) {
        Object receiver = linkRequest.getReceiver();
        if (!(receiver instanceof DynamicMethod)) {
            return null;
        }
        CallSiteDescriptor desc = linkRequest.getCallSiteDescriptor();
        if (desc.getNameTokenCount() != 2 && desc.getNameToken(0) != "dyn") {
            return null;
        }
        String operator = desc.getNameToken(1);
        if (operator == "call") {
            MethodHandle invocation = ((DynamicMethod)receiver).getInvocation(CallSiteDescriptorFactory.dropParameterTypes(desc, 0, 1), linkerServices);
            if (invocation == null) {
                return null;
            }
            return new GuardedInvocation(MethodHandles.dropArguments(invocation, 0, new Class[]{desc.getMethodType().parameterType(0)}), Guards.getIdentityGuard(receiver));
        }
        return null;
    }
}

