/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.dynalink.beans;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.util.StringTokenizer;
import org.dynalang.dynalink.CallSiteDescriptor;
import org.dynalang.dynalink.beans.DynamicMethod;
import org.dynalang.dynalink.linker.LinkerServices;
import org.dynalang.dynalink.support.Guards;

abstract class SingleDynamicMethod
extends DynamicMethod {
    SingleDynamicMethod(String name) {
        super(name);
    }

    abstract boolean isVarArgs();

    abstract MethodType getMethodType();

    abstract MethodHandle getTarget(MethodHandles.Lookup var1);

    @Override
    MethodHandle getInvocation(CallSiteDescriptor callSiteDescriptor, LinkerServices linkerServices) {
        return SingleDynamicMethod.getInvocation(this.getTarget(callSiteDescriptor.getLookup()), callSiteDescriptor.getMethodType(), linkerServices);
    }

    @Override
    SingleDynamicMethod getMethodForExactParamTypes(String paramTypes) {
        return SingleDynamicMethod.typeMatchesDescription(paramTypes, this.getMethodType()) ? this : null;
    }

    @Override
    boolean contains(SingleDynamicMethod method) {
        return this.getMethodType().parameterList().equals(method.getMethodType().parameterList());
    }

    static String getMethodNameWithSignature(MethodType type, String methodName) {
        String typeStr = type.toString();
        int retTypeIndex = typeStr.lastIndexOf(41) + 1;
        int secondParamIndex = typeStr.indexOf(44) + 1;
        if (secondParamIndex == 0) {
            secondParamIndex = retTypeIndex - 1;
        }
        return typeStr.substring(retTypeIndex) + " " + methodName + "(" + typeStr.substring(secondParamIndex, retTypeIndex);
    }

    static MethodHandle getInvocation(MethodHandle target, MethodType callSiteType, LinkerServices linkerServices) {
        MethodType methodType = target.type();
        int paramsLen = methodType.parameterCount();
        boolean varArgs = target.isVarargsCollector();
        MethodHandle fixTarget = varArgs ? target.asFixedArity() : target;
        int fixParamsLen = varArgs ? paramsLen - 1 : paramsLen;
        int argsLen = callSiteType.parameterCount();
        if (argsLen < fixParamsLen) {
            return null;
        }
        if (argsLen == fixParamsLen) {
            MethodHandle matchedMethod = varArgs ? MethodHandles.insertArguments(fixTarget, fixParamsLen, Array.newInstance(((Class)methodType.parameterType(fixParamsLen)).getComponentType(), 0)) : fixTarget;
            return SingleDynamicMethod.createConvertingInvocation(matchedMethod, linkerServices, callSiteType);
        }
        if (!varArgs) {
            return null;
        }
        TypeDescriptor.OfField varArgType = methodType.parameterType(fixParamsLen);
        if (argsLen == paramsLen) {
            TypeDescriptor.OfField callSiteLastArgType = callSiteType.parameterType(fixParamsLen);
            if (((Class)varArgType).isAssignableFrom((Class<?>)callSiteLastArgType)) {
                return SingleDynamicMethod.createConvertingInvocation(target, linkerServices, callSiteType).asVarargsCollector((Class<?>)callSiteLastArgType);
            }
            if (!linkerServices.canConvert((Class<?>)callSiteLastArgType, (Class<?>)varArgType)) {
                return SingleDynamicMethod.createConvertingInvocation(SingleDynamicMethod.collectArguments(fixTarget, argsLen), linkerServices, callSiteType);
            }
            return MethodHandles.guardWithTest(Guards.isInstance(varArgType, fixParamsLen, callSiteType), SingleDynamicMethod.createConvertingInvocation(fixTarget, linkerServices, callSiteType), SingleDynamicMethod.createConvertingInvocation(SingleDynamicMethod.collectArguments(fixTarget, argsLen), linkerServices, callSiteType));
        }
        return SingleDynamicMethod.createConvertingInvocation(SingleDynamicMethod.collectArguments(fixTarget, argsLen), linkerServices, callSiteType);
    }

    static MethodHandle collectArguments(MethodHandle target, int parameterCount) {
        MethodType methodType = target.type();
        int fixParamsLen = methodType.parameterCount() - 1;
        TypeDescriptor.OfField arrayType = methodType.parameterType(fixParamsLen);
        return target.asCollector((Class<?>)arrayType, parameterCount - fixParamsLen);
    }

    private static MethodHandle createConvertingInvocation(MethodHandle sizedMethod, LinkerServices linkerServices, MethodType callSiteType) {
        return linkerServices.asType(sizedMethod, callSiteType);
    }

    private static boolean typeMatchesDescription(String paramTypes, MethodType type) {
        StringTokenizer tok = new StringTokenizer(paramTypes, ", ");
        for (int i = 1; i < type.parameterCount(); ++i) {
            if (tok.hasMoreTokens() && SingleDynamicMethod.typeNameMatches(tok.nextToken(), type.parameterType(i))) continue;
            return false;
        }
        return !tok.hasMoreTokens();
    }

    private static boolean typeNameMatches(String typeName, Class<?> type) {
        return typeName.equals(typeName.indexOf(46) == -1 ? type.getSimpleName() : type.getCanonicalName());
    }
}

