/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.dynalink.support;

import org.dynalang.dynalink.CallSiteDescriptor;
import org.dynalang.dynalink.linker.LinkRequest;
import org.dynalang.dynalink.support.CallSiteDescriptorFactory;
import org.dynalang.dynalink.support.LinkRequestImpl;

public class RuntimeContextLinkRequestImpl
extends LinkRequestImpl {
    private final int runtimeContextArgCount;
    private LinkRequestImpl contextStrippedRequest;

    public RuntimeContextLinkRequestImpl(CallSiteDescriptor callSiteDescriptor, boolean callSiteUnstable, Object[] arguments, int runtimeContextArgCount) {
        super(callSiteDescriptor, callSiteUnstable, arguments);
        if (runtimeContextArgCount < 1) {
            throw new IllegalArgumentException("runtimeContextArgCount < 1");
        }
        this.runtimeContextArgCount = runtimeContextArgCount;
    }

    @Override
    public LinkRequest withoutRuntimeContext() {
        if (this.contextStrippedRequest == null) {
            this.contextStrippedRequest = new LinkRequestImpl(CallSiteDescriptorFactory.dropParameterTypes(this.getCallSiteDescriptor(), 1, this.runtimeContextArgCount + 1), this.isCallSiteUnstable(), this.getTruncatedArguments());
        }
        return this.contextStrippedRequest;
    }

    @Override
    public LinkRequest replaceArguments(CallSiteDescriptor callSiteDescriptor, Object[] arguments) {
        return new RuntimeContextLinkRequestImpl(callSiteDescriptor, this.isCallSiteUnstable(), arguments, this.runtimeContextArgCount);
    }

    private Object[] getTruncatedArguments() {
        Object[] args = this.getArguments();
        Object[] newargs = new Object[args.length - this.runtimeContextArgCount];
        newargs[0] = args[0];
        System.arraycopy(args, this.runtimeContextArgCount + 1, newargs, 1, newargs.length - 1);
        return newargs;
    }
}

