/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.functional.ui;

import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.exception.OCSRuntimeException;
import com.ocs.dynamo.filter.OrPredicate;
import com.ocs.dynamo.filter.SimpleStringPredicate;
import com.ocs.dynamo.functional.domain.Domain;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.service.ServiceLocatorFactory;
import com.ocs.dynamo.ui.component.CustomFieldContext;
import com.ocs.dynamo.ui.component.DefaultVerticalLayout;
import com.ocs.dynamo.ui.composite.layout.BaseCustomComponent;
import com.ocs.dynamo.ui.composite.layout.FormOptions;
import com.ocs.dynamo.ui.composite.layout.ServiceBasedSplitLayout;
import com.ocs.dynamo.ui.provider.QueryType;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.vaadin.componentfactory.EnhancedFormLayout;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.provider.SortOrder;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class MultiDomainEditLayout
extends BaseCustomComponent {
    private static final long serialVersionUID = 4410282343830892631L;
    private Consumer<Class<? extends Domain>> afterDomainSelected;
    private Supplier<Component> headerLayoutCreator;
    private List<Component> componentsToRegister = new ArrayList<Component>();
    private Map<Class<? extends Domain>, Map<String, Function<CustomFieldContext, Component>>> customFields = new HashMap<Class<? extends Domain>, Map<String, Function<CustomFieldContext, Component>>>();
    private Predicate<Class<?>> deleteAllowed = clazz -> true;
    private final List<Class<? extends Domain>> domainClasses;
    private BooleanSupplier editAllowed = () -> true;
    private final Map<Class<?>, String> entityModelOverrides = new HashMap();
    private final FormOptions formOptions;
    private VerticalLayout mainLayout;
    private Consumer<FlexLayout> postProcessButtonBar;
    private Consumer<VerticalLayout> postProcessSplitLayout;
    private Class<? extends Domain> selectedDomain;
    private VerticalLayout selectedDomainLayout;
    private ServiceBasedSplitLayout<?, ?> splitLayout;
    private Map<String, SerializablePredicate<?>> fieldFilters = new HashMap();
    private Map<String, String> fieldEntityModels = new HashMap<String, String>();

    public MultiDomainEditLayout(FormOptions formOptions, List<Class<? extends Domain>> domainClasses) {
        this.formOptions = formOptions;
        this.domainClasses = domainClasses;
    }

    public void addCustomField(String path, Class<? extends Domain> clazz, Function<CustomFieldContext, Component> function) {
        this.customFields.putIfAbsent(clazz, new HashMap());
        this.customFields.get(clazz).put(path, function);
    }

    public void addEntityModelOverride(Class<?> clazz, String reference) {
        this.entityModelOverrides.put(clazz, reference);
    }

    public void build() {
        if (this.mainLayout == null) {
            this.mainLayout = new DefaultVerticalLayout(true, true);
            EnhancedFormLayout form = new EnhancedFormLayout();
            this.mainLayout.add(new Component[]{form});
            ComboBox domainCombo = new ComboBox(this.message("ocs.select.domain"), this.getDomainClasses());
            domainCombo.setItemLabelGenerator((ItemLabelGenerator & Serializable)item -> this.getEntityModel((Class)item).getDisplayName(VaadinUtils.getLocale()));
            domainCombo.setSizeFull();
            domainCombo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.selectDomain((Class)event.getValue()));
            form.add(new Component[]{domainCombo});
            this.selectedDomainLayout = new DefaultVerticalLayout();
            this.mainLayout.add(new Component[]{this.selectedDomainLayout});
            if (!this.getDomainClasses().isEmpty()) {
                domainCombo.setValue(this.getDomainClasses().get(0));
            }
            this.add(new Component[]{this.mainLayout});
        }
    }

    public boolean checkDeleteAllowed(Class<?> clazz) {
        return this.deleteAllowed == null ? true : this.deleteAllowed.test(clazz);
    }

    private <T extends Domain> ServiceBasedSplitLayout<Integer, T> constructSplitLayout(Class<T> domainClass, FormOptions formOptions) {
        BaseService baseService = ServiceLocatorFactory.getServiceLocator().getServiceForEntity(domainClass);
        if (baseService != null) {
            this.componentsToRegister.clear();
            ServiceBasedSplitLayout layout = new ServiceBasedSplitLayout(baseService, this.getEntityModelFactory().getModel(domainClass), QueryType.ID_BASED, formOptions, new SortOrder((Object)"name", SortDirection.ASCENDING), new FetchJoinInformation[0]);
            layout.setAfterLayoutBuilt(this.postProcessSplitLayout);
            layout.setMustEnableComponent((component, t) -> {
                if (layout.getRemoveButton() == component) {
                    return this.deleteAllowed == null || this.deleteAllowed.test(this.getSelectedDomain());
                }
                return true;
            });
            layout.setHeaderLayoutCreator(this.headerLayoutCreator);
            layout.setPostProcessMainButtonBar(this.postProcessButtonBar);
            layout.setQuickSearchFilterCreator(value -> new OrPredicate(new SerializablePredicate[]{new SimpleStringPredicate("name", value, false, false), new SimpleStringPredicate("code", value, false, false)}));
            layout.setEditAllowed(this.getEditAllowed());
            if (this.customFields.get(domainClass) != null) {
                for (Map.Entry<String, Function<CustomFieldContext, Component>> entry : this.customFields.get(domainClass).entrySet()) {
                    layout.addCustomField(entry.getKey(), entry.getValue());
                }
            }
            this.fieldFilters.forEach((arg_0, arg_1) -> ((ServiceBasedSplitLayout)layout).addFieldFilter(arg_0, arg_1));
            this.fieldEntityModels.forEach((arg_0, arg_1) -> ((ServiceBasedSplitLayout)layout).addFieldEntityModel(arg_0, arg_1));
            layout.build();
            for (Component comp : this.componentsToRegister) {
                layout.registerComponent(comp);
            }
            return layout;
        }
        throw new OCSRuntimeException(this.message("ocs.no.service.class.found", new Object[]{domainClass}));
    }

    private <T> EntityModel<T> getEntityModel(Class<T> domainClass) {
        String override = this.entityModelOverrides.get(domainClass);
        return override != null ? this.getEntityModelFactory().getModel(override, domainClass) : this.getEntityModelFactory().getModel(domainClass);
    }

    public Domain getSelectedItem() {
        return (Domain)this.splitLayout.getSelectedItem();
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.build();
    }

    public final void registerComponent(Component comp) {
        this.componentsToRegister.add(comp);
    }

    public final void reload() {
        if (this.splitLayout != null) {
            this.splitLayout.reload();
        }
    }

    public final void selectDomain(Class<? extends Domain> clazz) {
        this.selectedDomain = clazz;
        ServiceBasedSplitLayout<Integer, ? extends Domain> layout = this.constructSplitLayout(clazz, this.formOptions);
        this.selectedDomainLayout.replace(this.splitLayout, layout);
        this.splitLayout = layout;
        if (this.afterDomainSelected != null) {
            this.afterDomainSelected.accept(clazz);
        }
    }

    public final void addFieldEntityModel(String path, String reference) {
        this.fieldEntityModels.put(path, reference);
    }

    public void addFieldFilter(String property, SerializablePredicate<?> filter) {
        this.fieldFilters.put(property, filter);
    }

    public Consumer<Class<? extends Domain>> getAfterDomainSelected() {
        return this.afterDomainSelected;
    }

    public void setAfterDomainSelected(Consumer<Class<? extends Domain>> afterDomainSelected) {
        this.afterDomainSelected = afterDomainSelected;
    }

    public Supplier<Component> getHeaderLayoutCreator() {
        return this.headerLayoutCreator;
    }

    public void setHeaderLayoutCreator(Supplier<Component> headerLayoutCreator) {
        this.headerLayoutCreator = headerLayoutCreator;
    }

    public Predicate<Class<?>> getDeleteAllowed() {
        return this.deleteAllowed;
    }

    public void setDeleteAllowed(Predicate<Class<?>> deleteAllowed) {
        this.deleteAllowed = deleteAllowed;
    }

    public List<Class<? extends Domain>> getDomainClasses() {
        return this.domainClasses;
    }

    public BooleanSupplier getEditAllowed() {
        return this.editAllowed;
    }

    public void setEditAllowed(BooleanSupplier editAllowed) {
        this.editAllowed = editAllowed;
    }

    public Consumer<FlexLayout> getPostProcessButtonBar() {
        return this.postProcessButtonBar;
    }

    public void setPostProcessButtonBar(Consumer<FlexLayout> postProcessButtonBar) {
        this.postProcessButtonBar = postProcessButtonBar;
    }

    public Consumer<VerticalLayout> getPostProcessSplitLayout() {
        return this.postProcessSplitLayout;
    }

    public void setPostProcessSplitLayout(Consumer<VerticalLayout> postProcessSplitLayout) {
        this.postProcessSplitLayout = postProcessSplitLayout;
    }

    public Class<? extends Domain> getSelectedDomain() {
        return this.selectedDomain;
    }

    public ServiceBasedSplitLayout<?, ?> getSplitLayout() {
        return this.splitLayout;
    }

    public Map<String, SerializablePredicate<?>> getFieldFilters() {
        return this.fieldFilters;
    }

    public Map<String, String> getFieldEntityModels() {
        return this.fieldEntityModels;
    }
}

