/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.dao.query;

import com.ocs.dynamo.domain.AbstractEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class DataSetIterator<ID extends Serializable, T extends AbstractEntity<ID>> {
    private static final int PAGE_SIZE = 2000;
    private List<ID> idList;
    private List<T> page;
    private int index;
    private int lastRead;
    private int indexInPage;
    private int pageSize;

    public DataSetIterator(List<ID> idList) {
        this(idList, 2000);
    }

    public DataSetIterator(List<ID> idList, int pageSize) {
        this.idList = idList;
        this.index = 0;
        this.lastRead = 0;
        this.indexInPage = 0;
        this.pageSize = pageSize;
    }

    public T next() {
        if (this.index > this.idList.size()) {
            return null;
        }
        if (this.index >= this.lastRead) {
            ArrayList<ID> ids = new ArrayList<ID>();
            for (int i = 0; i < this.pageSize && this.index + i < this.idList.size(); ++i) {
                ids.add(this.idList.get(this.index + i));
            }
            this.page = !ids.isEmpty() ? this.readPage(ids) : new ArrayList<T>();
            this.lastRead = this.index + ids.size();
            this.indexInPage = 0;
        }
        if (this.indexInPage < this.page.size()) {
            AbstractEntity t = (AbstractEntity)this.page.get(this.indexInPage);
            ++this.index;
            ++this.indexInPage;
            return (T)t;
        }
        return null;
    }

    protected abstract List<T> readPage(List<ID> var1);

    public int size() {
        return this.idList.size();
    }
}

