/*
 * Decompiled with CFR 0.152.
 */
package org.dynodict.plugin.download;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JvmStreamsKt;
import org.dynodict.mapper.MetadataMapperKt;
import org.dynodict.model.metadata.BucketsMetadata;
import org.dynodict.plugin.download.DownloadStringsTask;
import org.dynodict.plugin.evaluator.ParametersEvaluator;
import org.dynodict.plugin.ext.ExtensionsKt;
import org.dynodict.plugin.generation.ExtensionFunctionGenerator;
import org.dynodict.plugin.generation.ObjectsGenerator;
import org.dynodict.plugin.generation.StringModel;
import org.dynodict.plugin.generation.TreeInflater;
import org.dynodict.remote.RemoteManagerImpl;
import org.dynodict.remote.RemoteSettings;
import org.dynodict.remote.model.bucket.RemoteBucket;
import org.dynodict.remote.model.bucket.RemoteDString;
import org.dynodict.remote.model.metadata.RemoteBucketsMetadata;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 72\u00020\u0001:\u00017B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010!\u001a\u00020\"H\u0007J \u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0014H\u0002J:\u0010)\u001a\u00020\"2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020\u00142\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040/2\u0006\u00100\u001a\u00020\u0004H\u0002J.\u00101\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040/2\u0006\u00102\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u0004H\u0002J \u00103\u001a\u00020\"2\u0006\u00104\u001a\u0002052\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0014H\u0002J\f\u00106\u001a\u00020\u0004*\u00020%H\u0002R&\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR&\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0013\u001a\u00020\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R&\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0007\"\u0004\b\u001b\u0010\tR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0007\"\u0004\b \u0010\t\u00a8\u00068"}, d2={"Lorg/dynodict/plugin/download/DownloadStringsTask;", "Lorg/gradle/api/DefaultTask;", "()V", "<set-?>", "", "assetsDirParam", "getAssetsDirParam", "()Ljava/lang/String;", "setAssetsDirParam", "(Ljava/lang/String;)V", "packageNameParam", "getPackageNameParam", "setPackageNameParam", "paramEvaluator", "Lorg/dynodict/plugin/evaluator/ParametersEvaluator;", "getParamEvaluator", "()Lorg/dynodict/plugin/evaluator/ParametersEvaluator;", "paramEvaluator$delegate", "Lkotlin/Lazy;", "projectDirectoryParam", "Ljava/io/File;", "getProjectDirectoryParam", "()Ljava/io/File;", "setProjectDirectoryParam", "(Ljava/io/File;)V", "sourcesDirParam", "getSourcesDirParam", "setSourcesDirParam", "treeInflater", "Lorg/dynodict/plugin/generation/TreeInflater;", "url", "getUrl", "setUrl", "download", "", "generateAssetsJson", "bucket", "Lorg/dynodict/remote/model/bucket/RemoteBucket;", "json", "Lkotlinx/serialization/json/Json;", "assetsDirectory", "generateSources", "roots", "", "Lorg/dynodict/plugin/generation/StringModel;", "folder", "customFormats", "", "packageName", "mapBucket", "sourceDir", "writeMetadataToAssets", "metadata", "Lorg/dynodict/model/metadata/BucketsMetadata;", "generateFilename", "Companion", "plugin"})
@SourceDebugExtension(value={"SMAP\nDownloadStringsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadStringsTask.kt\norg/dynodict/plugin/download/DownloadStringsTask\n+ 2 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n42#2:175\n42#2:180\n1549#3:176\n1620#3,3:177\n819#3:181\n847#3,2:182\n*S KotlinDebug\n*F\n+ 1 DownloadStringsTask.kt\norg/dynodict/plugin/download/DownloadStringsTask\n*L\n101#1:175\n128#1:180\n115#1:176\n115#1:177,3\n155#1:181\n155#1:182,2\n*E\n"})
public class DownloadStringsTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String sourcesDirParam = "";
    @NotNull
    private String assetsDirParam = "";
    @NotNull
    private String url = "https://raw.githubusercontent.com/mkovalyk/GraphicEditor/master/";
    @NotNull
    private String packageNameParam = "";
    @OutputDirectory
    @NotNull
    private File projectDirectoryParam = new File("");
    @NotNull
    private final TreeInflater treeInflater = new TreeInflater();
    @NotNull
    private final Lazy paramEvaluator$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ParametersEvaluator>(this){
        final /* synthetic */ DownloadStringsTask this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final ParametersEvaluator invoke() {
            return new ParametersEvaluator(this.this$0.getProjectDirectoryParam());
        }
    }));
    @NotNull
    public static final String PREFIX_DEFAULT_FILE = "default_";
    @NotNull
    public static final String METADATA_NAME = "metadata.json";
    @NotNull
    public static final String DYNODICT_EXT_NAME = "DynoDictExt.kt";
    @NotNull
    public static final String STRINGS_NAME = "Strings.kt";

    @Input
    @NotNull
    public final String getSourcesDirParam() {
        return this.sourcesDirParam;
    }

    @Option(option="output", description="Directory to generate source files")
    public final void setSourcesDirParam(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.sourcesDirParam = string;
    }

    @Input
    @NotNull
    public final String getAssetsDirParam() {
        return this.assetsDirParam;
    }

    @Option(option="assets", description="Directory to copy default assets files")
    public final void setAssetsDirParam(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.assetsDirParam = string;
    }

    @Input
    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @Option(option="url", description="Url of the repository to download metadata and buckets")
    public final void setUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.url = string;
    }

    @Input
    @NotNull
    public final String getPackageNameParam() {
        return this.packageNameParam;
    }

    @Option(option="package", description="Package name for the app")
    public final void setPackageNameParam(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.packageNameParam = string;
    }

    @NotNull
    public final File getProjectDirectoryParam() {
        return this.projectDirectoryParam;
    }

    public final void setProjectDirectoryParam(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.projectDirectoryParam = file;
    }

    private final ParametersEvaluator getParamEvaluator() {
        Lazy lazy = this.paramEvaluator$delegate;
        return (ParametersEvaluator)lazy.getValue();
    }

    @TaskAction
    public final void download() {
        Json json2 = JsonKt.Json$default(null, (Function1)download.json.1.INSTANCE, (int)1, null);
        File assetsDir = this.getParamEvaluator().evaluateAssetsFolder(this.assetsDirParam);
        Pair<File, String> pair = this.getParamEvaluator().evaluateSourcesAndPackage(this.sourcesDirParam, this.packageNameParam);
        File sourcesDir = (File)pair.component1();
        String packageName = (String)pair.component2();
        System.out.println((Object)("Download task. Assets - " + assetsDir + ", sources - " + sourcesDir));
        RemoteManagerImpl remoteManager = new RemoteManagerImpl(new RemoteSettings(this.url), (StringFormat)json2);
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(remoteManager, this, json2, assetsDir, sourcesDir, packageName, null){
            Object L$0;
            int label;
            final /* synthetic */ RemoteManagerImpl $remoteManager;
            final /* synthetic */ DownloadStringsTask this$0;
            final /* synthetic */ Json $json;
            final /* synthetic */ File $assetsDir;
            final /* synthetic */ File $sourcesDir;
            final /* synthetic */ String $packageName;
            {
                this.$remoteManager = $remoteManager;
                this.this$0 = $receiver;
                this.$json = $json;
                this.$assetsDir = $assetsDir;
                this.$sourcesDir = $sourcesDir;
                this.$packageName = $packageName;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var17_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.$remoteManager.getMetadata((Continuation)this);
                        if (v0 == var17_2) {
                            return var17_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        v1 = (RemoteBucketsMetadata)v0;
                        if (v1 == null) {
                            throw new IllegalStateException("There is an error during retrieving of the metadata");
                        }
                        metadata = v1;
                        metadataWithDefault = RemoteBucketsMetadata.copy$default((RemoteBucketsMetadata)metadata, null, (List)CollectionsKt.listOf((Object)metadata.getDefaultLanguage()), null, (int)5, null);
                        this.L$0 = metadata;
                        this.label = 2;
                        v2 = this.$remoteManager.getStrings(metadataWithDefault, (Continuation)this);
                        if (v2 == var17_2) {
                            return var17_2;
                        }
                        ** GOTO lbl28
                    }
                    case 2: {
                        metadata = (RemoteBucketsMetadata)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl28:
                        // 2 sources

                        buckets = (List)v2;
                        customFormats = new LinkedHashSet<E>();
                        var6_7 = buckets;
                        var7_8 = this.this$0;
                        var8_9 = this.$sourcesDir;
                        var9_10 = this.$packageName;
                        var10_11 = this.$json;
                        var11_12 = this.$assetsDir;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (RemoteBucket)element$iv;
                            $i$a$-forEach-DownloadStringsTask$download$1$1 = false;
                            DownloadStringsTask.access$mapBucket(var7_8, it, customFormats, var8_9, var9_10);
                            DownloadStringsTask.access$generateAssetsJson(var7_8, it, var10_11, var11_12);
                        }
                        DownloadStringsTask.access$writeMetadataToAssets(this.this$0, MetadataMapperKt.toDomainMetadata((RemoteBucketsMetadata)metadata), this.$json, this.$assetsDir);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void writeMetadataToAssets(BucketsMetadata metadata, Json json2, File assetsDirectory) {
        void stream$iv;
        void $this$encodeToStream$iv;
        assetsDirectory.mkdirs();
        File file = new File(assetsDirectory, "default_metadata.json");
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        Json json3 = json2;
        OutputStream outputStream = new FileOutputStream(file);
        boolean $i$f$encodeToStream = false;
        $this$encodeToStream$iv.getSerializersModule();
        JvmStreamsKt.encodeToStream((Json)$this$encodeToStream$iv, (SerializationStrategy)((SerializationStrategy)BucketsMetadata.Companion.serializer()), (Object)metadata, (OutputStream)stream$iv);
    }

    private final void mapBucket(RemoteBucket bucket, Set<String> customFormats, File sourceDir, String packageName) {
        Map<String, StringModel> roots = this.treeInflater.generateTree(bucket);
        this.generateSources(roots, sourceDir, customFormats, packageName);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateAssetsJson(RemoteBucket bucket, Json json2, File assetsDirectory) {
        void stream$iv;
        void $this$encodeToStream$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = bucket.getTranslations();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RemoteDString remoteDString = (RemoteDString)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(RemoteDString.copy$default((RemoteDString)it, null, null, (List)CollectionsKt.emptyList(), (int)3, null));
        }
        List processed = (List)destination$iv$iv;
        RemoteBucket clearedBucket = RemoteBucket.copy$default((RemoteBucket)bucket, (int)0, (int)0, null, null, (List)processed, (int)15, null);
        String filename = this.generateFilename(bucket);
        File assetsFile = new File(assetsDirectory, PREFIX_DEFAULT_FILE + filename);
        if (assetsFile.exists()) {
            assetsFile.delete();
        }
        assetsFile.createNewFile();
        destination$iv$iv = json2;
        OutputStream $i$f$mapTo22 = new FileOutputStream(assetsFile);
        boolean $i$f$encodeToStream = false;
        $this$encodeToStream$iv.getSerializersModule();
        JvmStreamsKt.encodeToStream((Json)$this$encodeToStream$iv, (SerializationStrategy)((SerializationStrategy)RemoteBucket.Companion.serializer()), (Object)clearedBucket, (OutputStream)stream$iv);
    }

    private final String generateFilename(RemoteBucket $this$generateFilename) {
        String string;
        String string2 = $this$generateFilename.getName();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = $this$generateFilename.getLanguage()) == null) {
            string = "";
        }
        return ExtensionsKt.generateBucketName(string2, string, $this$generateFilename.getSchemeVersion());
    }

    /*
     * WARNING - void declaration
     */
    private final void generateSources(Map<String, StringModel> roots, File folder, Set<String> customFormats, String packageName) {
        String result = new ObjectsGenerator(packageName).generate(roots, customFormats);
        File file = new File(folder, STRINGS_NAME);
        if (!file.exists()) {
            file.createNewFile();
        }
        FilesKt.writeText$default((File)file, (String)result, null, (int)2, null);
        if (!((Collection)customFormats).isEmpty()) {
            void $this$filterNotTo$iv$iv;
            File extensionFile = new File(folder, DYNODICT_EXT_NAME);
            if (!extensionFile.exists()) {
                extensionFile.createNewFile();
            }
            Iterable $this$filterNot$iv = CollectionsKt.toList((Iterable)customFormats);
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (StringsKt.contains$default((CharSequence)it, (char)'%', (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filtered = (List)destination$iv$iv;
            System.out.println((Object)("Parameters which will be have custom Formatter: " + filtered));
            System.out.println((Object)("Amount of skipped due to default formatters: " + (customFormats.size() - filtered.size())));
            String extensionText = new ExtensionFunctionGenerator(packageName, 0, 2, null).generate(filtered);
            FilesKt.writeText$default((File)extensionFile, (String)extensionText, null, (int)2, null);
        }
    }

    public static final /* synthetic */ void access$writeMetadataToAssets(DownloadStringsTask $this, BucketsMetadata metadata, Json json2, File assetsDirectory) {
        $this.writeMetadataToAssets(metadata, json2, assetsDirectory);
    }

    public static final /* synthetic */ void access$mapBucket(DownloadStringsTask $this, RemoteBucket bucket, Set customFormats, File sourceDir, String packageName) {
        $this.mapBucket(bucket, customFormats, sourceDir, packageName);
    }

    public static final /* synthetic */ void access$generateAssetsJson(DownloadStringsTask $this, RemoteBucket bucket, Json json2, File assetsDirectory) {
        $this.generateAssetsJson(bucket, json2, assetsDirectory);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/dynodict/plugin/download/DownloadStringsTask$Companion;", "", "()V", "DYNODICT_EXT_NAME", "", "METADATA_NAME", "PREFIX_DEFAULT_FILE", "STRINGS_NAME", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

