/*
 * Decompiled with CFR 0.152.
 */
package org.dynodict.plugin.evaluator;

import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0007H\u0002J\"\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/dynodict/plugin/evaluator/ParametersEvaluator;", "", "projectDirectory", "Ljava/io/File;", "(Ljava/io/File;)V", "evaluateAssetsFolder", "assetsFolder", "", "evaluateSourceFolder", "sourcesFolder", "evaluateSourcesAndPackage", "Lkotlin/Pair;", "packageName", "Companion", "plugin"})
@SourceDebugExtension(value={"SMAP\nParametersEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParametersEvaluator.kt\norg/dynodict/plugin/evaluator/ParametersEvaluator\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n18#2:75\n26#3:76\n1#4:77\n*S KotlinDebug\n*F\n+ 1 ParametersEvaluator.kt\norg/dynodict/plugin/evaluator/ParametersEvaluator\n*L\n25#1:75\n25#1:76\n*E\n"})
public final class ParametersEvaluator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File projectDirectory;
    @NotNull
    public static final String DEFAULT_ASSETS_FOLDER = "/src/main/assets";
    @NotNull
    public static final String DEFAULT_SOURCES_JAVA_FOLDER = "/src/main/java";
    @NotNull
    public static final String DEFAULT_SOURCES_KOTLIN_FOLDER = "/src/main/kotlin";

    public ParametersEvaluator(@NotNull File projectDirectory) {
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        this.projectDirectory = projectDirectory;
    }

    @NotNull
    public final Pair<File, String> evaluateSourcesAndPackage(@NotNull String sourcesFolder, @NotNull String packageName) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)sourcesFolder, (String)"sourcesFolder");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        File sourcesFolderFile = this.evaluateSourceFolder(sourcesFolder);
        if (((CharSequence)packageName).length() > 0) {
            String folder = StringsKt.replace$default((String)packageName, (String)".", (String)"/", (boolean)false, (int)4, null);
            pair = new Pair((Object)new File(sourcesFolderFile, folder), (Object)packageName);
        } else {
            File folder = sourcesFolderFile;
            while (true) {
                File[] $this$orEmpty$iv = folder.listFiles();
                boolean $i$f$orEmpty = false;
                File[] fileArray = $this$orEmpty$iv;
                if ($this$orEmpty$iv == null) {
                    boolean $i$f$emptyArray = false;
                    fileArray = new File[]{};
                }
                if (fileArray.length != 1) break;
                File[] fileArray2 = folder.listFiles();
                Intrinsics.checkNotNull((Object)fileArray2);
                File child = fileArray2[0];
                if (!child.isDirectory()) break;
                Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                folder = child;
            }
            String string = folder.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"folder.absolutePath");
            String string2 = sourcesFolderFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sourcesFolderFile.absolutePath");
            String evaluatedPackageName = StringsKt.replace$default((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)string, (CharSequence)string2), (CharSequence)"/"), (String)"/", (String)".", (boolean)false, (int)4, null);
            pair = new Pair((Object)folder, (Object)evaluatedPackageName);
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final File evaluateSourceFolder(String sourcesFolder) {
        File file;
        if (((CharSequence)sourcesFolder).length() > 0) {
            file = new File(this.projectDirectory, sourcesFolder);
        } else {
            void var3_2;
            File temp = new File(this.projectDirectory, DEFAULT_SOURCES_KOTLIN_FOLDER);
            if (!temp.exists() && !(temp = new File(this.projectDirectory, DEFAULT_SOURCES_JAVA_FOLDER)).exists()) {
                throw new IllegalStateException("Can't find any source Folder");
            }
            file = var3_2;
        }
        File sourcesFolderFile = file;
        return sourcesFolderFile;
    }

    @NotNull
    public final File evaluateAssetsFolder(@NotNull String assetsFolder) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)assetsFolder, (String)"assetsFolder");
        File file = this.projectDirectory;
        CharSequence charSequence2 = assetsFolder;
        if (charSequence2.length() == 0) {
            File file2 = file;
            boolean bl = false;
            charSequence = DEFAULT_ASSETS_FOLDER;
            file = file2;
        } else {
            charSequence = charSequence2;
        }
        String string = (String)charSequence;
        File file3 = file;
        File assetsFolderFile = new File(file3, string);
        if (!assetsFolderFile.exists()) {
            assetsFolderFile.mkdirs();
        }
        return assetsFolderFile;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/dynodict/plugin/evaluator/ParametersEvaluator$Companion;", "", "()V", "DEFAULT_ASSETS_FOLDER", "", "DEFAULT_SOURCES_JAVA_FOLDER", "DEFAULT_SOURCES_KOTLIN_FOLDER", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

