/*
 * Decompiled with CFR 0.152.
 */
package org.dynodict.plugin.generation;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.dynodict.plugin.generation.StringBuilderExtKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tJ\u001e\u0010\n\u001a\u00020\u000b*\u00060\fj\u0002`\r2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0002J\u001e\u0010\u000e\u001a\u00020\u000b*\u00060\fj\u0002`\r2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/dynodict/plugin/generation/ExtensionFunctionGenerator;", "", "packageName", "", "paramsThreshold", "", "(Ljava/lang/String;I)V", "generate", "formats", "", "generateFormattersAsMap", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "generateNamedFormatters", "Companion", "plugin"})
@SourceDebugExtension(value={"SMAP\nExtensionFunctionGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionFunctionGenerator.kt\norg/dynodict/plugin/generation/ExtensionFunctionGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,78:1\n1271#2,2:79\n1285#2,4:81\n1864#2,3:85\n215#3,2:88\n*S KotlinDebug\n*F\n+ 1 ExtensionFunctionGenerator.kt\norg/dynodict/plugin/generation/ExtensionFunctionGenerator\n*L\n43#1:79,2\n43#1:81,4\n47#1:85,3\n52#1:88,2\n*E\n"})
public final class ExtensionFunctionGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String packageName;
    private final int paramsThreshold;
    public static final int DEFAULT_PARAMS_THRESHOLD = 8;

    public ExtensionFunctionGenerator(@NotNull String packageName, int paramsThreshold) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        this.packageName = packageName;
        this.paramsThreshold = paramsThreshold;
    }

    public /* synthetic */ ExtensionFunctionGenerator(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 8;
        }
        this(string, n);
    }

    @NotNull
    public final String generate(@NotNull List<String> formats) {
        StringBuilder builder;
        Intrinsics.checkNotNullParameter(formats, (String)"formats");
        if (formats.isEmpty()) {
            return "";
        }
        StringBuilder $this$generate_u24lambda_u240 = builder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder = $this$generate_u24lambda_u240.append("package " + this.packageName);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        Intrinsics.checkNotNullExpressionValue((Object)$this$generate_u24lambda_u240.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder2 = $this$generate_u24lambda_u240.append("import org.dynodict.formatter.DynoDictFormatter");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder3 = $this$generate_u24lambda_u240.append("import org.dynodict.DynoDict");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        Intrinsics.checkNotNullExpressionValue((Object)$this$generate_u24lambda_u240.append('\n'), (String)"append('\\n')");
        $this$generate_u24lambda_u240.append("fun DynoDict.Companion.registerFormatters(");
        if (formats.size() <= this.paramsThreshold) {
            this.generateNamedFormatters($this$generate_u24lambda_u240, formats);
        } else {
            this.generateFormattersAsMap($this$generate_u24lambda_u240, formats);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateNamedFormatters(StringBuilder $this$generateNamedFormatters, List<String> formats) {
        Object element$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)$this$generateNamedFormatters.append('\n'), (String)"append('\\n')");
        Iterable $this$associateWith$iv = formats;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        Iterator iterator = $this$associateWithTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            element$iv$iv = iterator.next();
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            String string2 = StringsKt.replace$default((String)StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString(), (String)".", (String)"", (boolean)false, (int)4, null), (String)"_", (String)"", (boolean)false, (int)4, null);
            map.put(t, string2);
        }
        Map formatsNormalized = result$iv;
        Iterable $this$forEachIndexed$iv = formatsNormalized.values();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void item;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (String)item$iv;
            int index = n;
            boolean bl = false;
            StringBuilderExtKt.appendWithTab($this$generateNamedFormatters, (String)item + "Formatter: DynoDictFormatter<*>", 1);
            StringBuilder stringBuilder = $this$generateNamedFormatters.append(index == CollectionsKt.getLastIndex(formats) ? "\n) {" : ",");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        }
        StringBuilderExtKt.appendLineWithTab($this$generateNamedFormatters, "with(DynoDict.instance) {", 1);
        Map $this$forEach$iv = formatsNormalized;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            StringBuilderExtKt.appendLineWithTab($this$generateNamedFormatters, "registerFormatter(\"" + it.getKey() + "\", " + it.getValue() + "Formatter)", 2);
        }
        StringBuilderExtKt.appendLineWithTab($this$generateNamedFormatters, "}", 1);
        StringBuilder stringBuilder = $this$generateNamedFormatters.append("}");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
    }

    private final void generateFormattersAsMap(StringBuilder $this$generateFormattersAsMap, List<String> formats) {
        StringBuilder stringBuilder = $this$generateFormattersAsMap.append("formats: Map<String, DynoDictFormatter<*>>) {");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        String names = CollectionsKt.joinToString$default((Iterable)formats, (CharSequence)"\", \"", (CharSequence)"\"", (CharSequence)"\"", (int)0, null, null, (int)56, null);
        StringBuilderExtKt.appendLineWithTab($this$generateFormattersAsMap, "val list = listOf(" + names + ")", 1);
        StringBuilderExtKt.appendLineWithTab($this$generateFormattersAsMap, "val result = list - formats.keys", 1);
        StringBuilderExtKt.appendLineWithTab($this$generateFormattersAsMap, "if (result.isNotEmpty()) {", 1);
        StringBuilderExtKt.appendLineWithTab($this$generateFormattersAsMap, "throw IllegalStateException(\"Not all formatters passed. Please also add remaining: $result\")", 2);
        StringBuilderExtKt.appendLineWithTab($this$generateFormattersAsMap, "}", 1);
        StringBuilder stringBuilder2 = $this$generateFormattersAsMap.append("}");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/dynodict/plugin/generation/ExtensionFunctionGenerator$Companion;", "", "()V", "DEFAULT_PARAMS_THRESHOLD", "", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

