/*
 * Decompiled with CFR 0.152.
 */
package org.dynodict.plugin.generation;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.dynodict.plugin.exception.IllegalTypeException;
import org.dynodict.plugin.generation.StringBuilderExtKt;
import org.dynodict.plugin.generation.StringModel;
import org.dynodict.remote.model.bucket.RemoteDString;
import org.dynodict.remote.model.bucket.RemoteParameter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0007\u001a\u00020\u00032\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bJ\f\u0010\f\u001a\u00020\u0003*\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f*\u00060\u0010j\u0002`\u0011H\u0002J@\u0010\u0012\u001a\u00020\u000f*\u00060\u0010j\u0002`\u00112\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0002J\f\u0010\u0018\u001a\u00020\u0003*\u00020\rH\u0002J.\u0010\u0019\u001a\u00020\u000f*\u00060\u0010j\u0002`\u00112\u0006\u0010\u0014\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0002J\u0012\u0010\u001b\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\r0\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/dynodict/plugin/generation/ObjectsGenerator;", "", "packageName", "", "(Ljava/lang/String;)V", "types", "", "generate", "roots", "Lorg/dynodict/plugin/generation/StringModel;", "customFormats", "", "generateCode", "Lorg/dynodict/remote/model/bucket/RemoteParameter;", "generateHeader", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "generateModel", "key", "model", "parent", "level", "", "identifyType", "insertValueWithParam", "Lorg/dynodict/remote/model/bucket/RemoteDString;", "prepareListOfParameters", "", "plugin"})
@SourceDebugExtension(value={"SMAP\nObjectsGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectsGenerator.kt\norg/dynodict/plugin/generation/ObjectsGenerator\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n215#2,2:119\n215#2,2:121\n1864#3,3:123\n*S KotlinDebug\n*F\n+ 1 ObjectsGenerator.kt\norg/dynodict/plugin/generation/ObjectsGenerator\n*L\n15#1:119,2\n55#1:121,2\n69#1:123,3\n*E\n"})
public final class ObjectsGenerator {
    @NotNull
    private final String packageName;
    @NotNull
    private final Map<String, String> types;

    public ObjectsGenerator(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        this.packageName = packageName;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"string", (Object)"String"), TuplesKt.to((Object)"int", (Object)"Int"), TuplesKt.to((Object)"long", (Object)"Long"), TuplesKt.to((Object)"float", (Object)"Float"), TuplesKt.to((Object)"double", (Object)"Double")};
        this.types = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final String generate(@NotNull Map<String, StringModel> roots, @NotNull Set<String> customFormats) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter(customFormats, (String)"customFormats");
        StringBuilder builder = new StringBuilder();
        this.generateHeader(builder);
        Map<String, StringModel> $this$forEach$iv = roots;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, StringModel>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, StringModel> element$iv;
            Map.Entry<String, StringModel> it = element$iv = iterator.next();
            boolean bl = false;
            this.generateModel(builder, it.getKey(), it.getValue(), null, 0, customFormats);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    private final void generateHeader(StringBuilder $this$generateHeader) {
        StringBuilder stringBuilder = $this$generateHeader.append("package " + this.packageName);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        Intrinsics.checkNotNullExpressionValue((Object)$this$generateHeader.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder2 = $this$generateHeader.append("import org.dynodict.DynoDict");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder3 = $this$generateHeader.append("import org.dynodict.model.StringKey");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder4 = $this$generateHeader.append("import org.dynodict.model.Parameter");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        Intrinsics.checkNotNullExpressionValue((Object)$this$generateHeader.append('\n'), (String)"append('\\n')");
    }

    private final void generateModel(StringBuilder $this$generateModel, String key, StringModel model, String parent, int level, Set<String> customFormats) {
        RemoteDString value = model.getValue();
        String string = parent;
        Object parentClass = string == null ? "" : ", " + string;
        String signature = "object " + key + " : StringKey(\"" + key + "\"" + (String)parentClass + ") {";
        StringBuilderExtKt.appendLineWithTab($this$generateModel, signature, level);
        if (value != null) {
            this.insertValueWithParam($this$generateModel, value, level, customFormats);
        }
        Map<String, StringModel> it = model.getChildren();
        boolean bl = false;
        if (!it.isEmpty()) {
            if (value != null) {
                Intrinsics.checkNotNullExpressionValue((Object)$this$generateModel.append('\n'), (String)"append('\\n')");
            }
            Map<String, StringModel> $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, StringModel>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, StringModel> element$iv;
                Map.Entry<String, StringModel> child = element$iv = iterator.next();
                boolean bl2 = false;
                this.generateModel($this$generateModel, child.getKey(), child.getValue(), key, level + 1, customFormats);
            }
        }
        StringBuilderExtKt.appendLineWithTab($this$generateModel, "}", level);
    }

    /*
     * WARNING - void declaration
     */
    private final void insertValueWithParam(StringBuilder $this$insertValueWithParam, RemoteDString model, int level, Set<String> customFormats) {
        if (model.getParams().isEmpty()) {
            StringBuilderExtKt.appendLineWithTab($this$insertValueWithParam, "val value: String", level + 1);
            StringBuilderExtKt.appendLineWithTab($this$insertValueWithParam, "get() = DynoDict.instance.get(this)", level + 2);
        } else {
            StringBuilderExtKt.appendWithTab($this$insertValueWithParam, "fun value(", level + 1);
            Iterable $this$forEachIndexed$iv = model.getParams();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void parameter;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                RemoteParameter remoteParameter = (RemoteParameter)item$iv;
                int index = n;
                boolean bl = false;
                String suffix = index < CollectionsKt.getLastIndex((List)model.getParams()) ? ", " : "";
                $this$insertValueWithParam.append(this.generateCode((RemoteParameter)parameter) + suffix);
                CharSequence charSequence = parameter.getFormat();
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
                String string = parameter.getFormat();
                Intrinsics.checkNotNull((Object)string);
                customFormats.add(string);
            }
            StringBuilder stringBuilder = $this$insertValueWithParam.append("): String {");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
            String paramsString = this.prepareListOfParameters(model.getParams());
            StringBuilderExtKt.appendLineWithTab($this$insertValueWithParam, "return DynoDict.instance.get(this" + paramsString + ")", level + 2);
            StringBuilderExtKt.appendLineWithTab($this$insertValueWithParam, "}", level + 1);
        }
    }

    private final String prepareListOfParameters(List<RemoteParameter> $this$prepareListOfParameters) {
        String params2 = CollectionsKt.joinToString$default((Iterable)$this$prepareListOfParameters, (CharSequence)",", null, null, (int)0, null, (Function1)((Function1)new Function1<RemoteParameter, CharSequence>(this){
            final /* synthetic */ ObjectsGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull RemoteParameter item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                String type = ObjectsGenerator.access$identifyType(this.this$0, item);
                String format = item.getFormat() == null ? "" : ", format = \"" + item.getFormat() + "\"";
                return "Parameter." + type + "Parameter(" + item.getKey() + ", key = \"" + item.getKey() + "\"" + format + ")";
            }
        }), (int)30, null);
        return ((CharSequence)params2).length() == 0 ? params2 : ", " + params2;
    }

    private final String generateCode(RemoteParameter $this$generateCode) {
        String evaluatedType = this.identifyType($this$generateCode);
        return $this$generateCode.getKey() + ": " + evaluatedType;
    }

    private final String identifyType(RemoteParameter $this$identifyType) {
        String string = $this$identifyType.getType();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        String evaluatedType = this.types.get(string2);
        if (evaluatedType == null) {
            throw new IllegalTypeException("This type (" + $this$identifyType.getType() + ") is not supported. Please use one of: " + this.types.keySet());
        }
        return evaluatedType;
    }

    public static final /* synthetic */ String access$identifyType(ObjectsGenerator $this, RemoteParameter $receiver) {
        return $this.identifyType($receiver);
    }
}

