/*
 * Decompiled with CFR 0.152.
 */
package org.dynodict.plugin.migration;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.dynodict.model.metadata.BucketMetadata;
import org.dynodict.model.metadata.BucketsMetadata;
import org.dynodict.plugin.ext.ExtensionsKt;
import org.dynodict.plugin.migration.MigrateStringsTask;
import org.dynodict.plugin.xml.entity.ResourcesParser;
import org.dynodict.remote.model.bucket.RemoteBucket;
import org.dynodict.remote.model.bucket.RemoteDString;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0007J0\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0004H\u0002R&\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR&\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR&\u0010\r\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001e\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R&\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\tR\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006("}, d2={"Lorg/dynodict/plugin/migration/MigrateStringsTask;", "Lorg/gradle/api/DefaultTask;", "()V", "<set-?>", "", "bucketName", "getBucketName", "()Ljava/lang/String;", "setBucketName", "(Ljava/lang/String;)V", "inputDirParam", "getInputDirParam", "setInputDirParam", "outputDirParam", "getOutputDirParam", "setOutputDirParam", "projectDirectoryParam", "Ljava/io/File;", "getProjectDirectoryParam", "()Ljava/io/File;", "setProjectDirectoryParam", "(Ljava/io/File;)V", "schemeVersion", "getSchemeVersion", "setSchemeVersion", "schemeVersionInt", "", "getSchemeVersionInt", "()I", "convert", "", "putMetadata", "outputFolder", "locale", "yaml", "Lkotlinx/serialization/json/Json;", "validateOutputParameter", "", "param", "Companion", "plugin"})
@SourceDebugExtension(value={"SMAP\nMigrateStringsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrateStringsTask.kt\norg/dynodict/plugin/migration/MigrateStringsTask\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,147:1\n113#2:148\n113#2:149\n*S KotlinDebug\n*F\n+ 1 MigrateStringsTask.kt\norg/dynodict/plugin/migration/MigrateStringsTask\n*L\n84#1:148\n115#1:149\n*E\n"})
public class MigrateStringsTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String inputDirParam = "";
    @NotNull
    private String outputDirParam = "";
    @NotNull
    private String schemeVersion = "1";
    @NotNull
    private String bucketName = "strings";
    @OutputDirectory
    @NotNull
    private File projectDirectoryParam = new File("");
    @NotNull
    public static final String PREFIX_DEFAULT_FILE = "default_";
    @NotNull
    public static final String METADATA_NAME = "metadata.json";
    @NotNull
    public static final String DYNODICT_EXT_NAME = "DynoDictExt.kt";
    @NotNull
    public static final String STRINGS_NAME = "Strings.kt";

    @Input
    @NotNull
    public final String getInputDirParam() {
        return this.inputDirParam;
    }

    @Option(option="input", description="Default is strings.xml")
    public final void setInputDirParam(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.inputDirParam = string;
    }

    @Input
    @NotNull
    public final String getOutputDirParam() {
        return this.outputDirParam;
    }

    @Option(option="output", description="It will place output in this folder. Default is ''")
    public final void setOutputDirParam(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.outputDirParam = string;
    }

    @Input
    @NotNull
    public final String getSchemeVersion() {
        return this.schemeVersion;
    }

    @Option(option="edition", description="Edition number. Resulting file will be named as 'bucketName-locale-schemeVersion.json'. Default is 1")
    public final void setSchemeVersion(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.schemeVersion = string;
    }

    private final int getSchemeVersionInt() {
        return Integer.parseInt(this.schemeVersion);
    }

    @Input
    @NotNull
    public final String getBucketName() {
        return this.bucketName;
    }

    @Option(option="bucketName", description="Name of the bucket. Resulting file will be named as 'bucketName-locale-schemeVersion.json'. Default is default")
    public final void setBucketName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.bucketName = string;
    }

    @NotNull
    public final File getProjectDirectoryParam() {
        return this.projectDirectoryParam;
    }

    public final void setProjectDirectoryParam(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.projectDirectoryParam = file;
    }

    @TaskAction
    public final void convert() {
        try {
            String locale;
            File file = new File(this.inputDirParam);
            List<RemoteDString> strings = new ResourcesParser().parse(FilesKt.readText$default((File)file, null, (int)1, null));
            Json json2 = JsonKt.Json$default(null, (Function1)convert.json.1.INSTANCE, (int)1, null);
            String[] stringArray = new String[]{"values-"};
            String string = (String)CollectionsKt.getOrNull((List)StringsKt.split$default((CharSequence)this.inputDirParam, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)1);
            if (string == null) {
                string = locale = "en";
            }
            if (this.validateOutputParameter(this.outputDirParam)) {
                File outputFolder = new File(this.projectDirectoryParam, this.outputDirParam);
                File jsonFile = new File(outputFolder, ExtensionsKt.generateBucketName(this.bucketName, locale, this.getSchemeVersionInt()));
                RemoteBucket bucket = new RemoteBucket(this.getSchemeVersionInt(), 1, this.bucketName, locale, strings);
                StringFormat $this$encodeToString$iv = (StringFormat)json2;
                boolean $i$f$encodeToString = false;
                $this$encodeToString$iv.getSerializersModule();
                String result = $this$encodeToString$iv.encodeToString((SerializationStrategy)RemoteBucket.Companion.serializer(), (Object)bucket);
                FilesKt.writeText$default((File)jsonFile, (String)result, null, (int)2, null);
                this.putMetadata(outputFolder, locale, json2, this.getSchemeVersionInt(), this.bucketName);
            }
        }
        catch (Exception e) {
            System.out.println((Object)("Exception: " + e));
        }
    }

    private final void putMetadata(File outputFolder, String locale, Json yaml, int schemeVersion, String bucketName) {
        File metadataFile = new File(outputFolder, METADATA_NAME);
        BucketsMetadata metadata = new BucketsMetadata(locale, CollectionsKt.listOf((Object)locale), CollectionsKt.listOf((Object)new BucketMetadata(bucketName, schemeVersion, 1, locale)));
        System.out.println((Object)("Output File: " + metadataFile.getAbsolutePath()));
        StringFormat $this$encodeToString$iv = (StringFormat)yaml;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        String metadataResult = $this$encodeToString$iv.encodeToString((SerializationStrategy)BucketsMetadata.Companion.serializer(), (Object)metadata);
        FilesKt.writeText$default((File)metadataFile, (String)metadataResult, null, (int)2, null);
    }

    private final boolean validateOutputParameter(String param) {
        File file;
        if (StringsKt.contains$default((CharSequence)param, (CharSequence)".json", (boolean)false, (int)2, null)) {
            System.out.println((Object)"Output parameter is not valid. It should be a folder");
            return false;
        }
        if (((CharSequence)param).length() > 0 && !(file = new File(this.projectDirectoryParam, param)).exists()) {
            file.mkdirs();
        }
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/dynodict/plugin/migration/MigrateStringsTask$Companion;", "", "()V", "DYNODICT_EXT_NAME", "", "METADATA_NAME", "PREFIX_DEFAULT_FILE", "STRINGS_NAME", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

