/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.annotation;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.easetech.easytest.converter.Converter;
import org.easetech.easytest.converter.ConverterManager;
import org.easetech.easytest.util.DataContext;
import org.junit.Assert;
import org.junit.experimental.theories.ParameterSignature;
import org.junit.experimental.theories.ParameterSupplier;
import org.junit.experimental.theories.ParametersSuppliedBy;
import org.junit.experimental.theories.PotentialAssignment;

@Retention(value=RetentionPolicy.RUNTIME)
@ParametersSuppliedBy(value=DataSupplier.class)
@Target(value={ElementType.METHOD, ElementType.TYPE, ElementType.PARAMETER})
public @interface Param {
    public String name() default "";

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DataSupplier
    extends ParameterSupplier {
        public List<PotentialAssignment> getValueSources(ParameterSignature signature) {
            Param provider = (Param)signature.getAnnotation(Param.class);
            String value = DataContext.getMethodName();
            if (value == null) {
                Assert.fail((String)"The framework could not locate the test data for the test method. If you are using TestData annotation, make sure you specify the test method name in the data file. In case you are using ParametersSuppliedBy annotation, make sure you are using the right ParameterSupplier subclass.");
            }
            List<PotentialAssignment> listOfData = null;
            Map<String, List<Map<String, Object>>> data = DataContext.getConvertedData();
            List<Map<String, Object>> methodData = data.get(value);
            if (methodData == null) {
                Assert.fail((String)("Data does not exist for the specified method with name :" + value + " .Please check " + "that the Data file contains the data for the given method name. A possible cause could be spelling mismatch."));
            }
            listOfData = signature.getType().isAssignableFrom(Map.class) ? this.convert(data.get(value)) : this.convert(signature.getType(), provider.name(), data.get(value));
            return listOfData;
        }

        private List<PotentialAssignment> convert(List<Map<String, Object>> convertFrom) {
            ArrayList<PotentialAssignment> finalData = new ArrayList<PotentialAssignment>();
            for (Map<String, Object> map : convertFrom) {
                finalData.add(PotentialAssignment.forValue((String)"", map));
            }
            return finalData;
        }

        private List<PotentialAssignment> convert(Class<?> idClass, String paramName, List<Map<String, Object>> convertFrom) {
            ArrayList<PotentialAssignment> finalData = new ArrayList<PotentialAssignment>();
            PropertyEditor editor = PropertyEditorManager.findEditor(idClass);
            if (editor != null) {
                for (Map<String, Object> object : convertFrom) {
                    if (paramName != null && !"".equals(paramName)) {
                        if (DataSupplier.getStringValue(paramName, object) != null) {
                            editor.setAsText(DataSupplier.getStringValue(paramName, object));
                        }
                    } else {
                        editor.setAsText(DataSupplier.getStringValue(idClass.getSimpleName(), object));
                    }
                    if (editor.getValue() == null) continue;
                    finalData.add(PotentialAssignment.forValue((String)"", (Object)editor.getValue()));
                }
            } else {
                Converter<?> converter = ConverterManager.findConverter(idClass);
                if (converter != null) {
                    for (Map<String, Object> object : convertFrom) {
                        finalData.add(PotentialAssignment.forValue((String)"", converter.convert(object)));
                    }
                } else {
                    Assert.fail((String)("Could not find either Editor or Converter instance for class :" + idClass));
                }
            }
            return finalData;
        }

        private static String getStringValue(String paramName, Map<String, Object> data) {
            String value = null;
            if (data.get(paramName) != null) {
                value = data.get(paramName).toString();
            }
            return value;
        }
    }
}

