/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.loader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.easetech.easytest._1.Entry;
import org.easetech.easytest._1.InputTestData;
import org.easetech.easytest._1.ObjectFactory;
import org.easetech.easytest._1.OutputData;
import org.easetech.easytest._1.TestMethod;
import org.easetech.easytest._1.TestRecord;
import org.easetech.easytest.loader.Loader;
import org.easetech.easytest.util.ResourceLoader;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLDataLoader
implements Loader {
    protected static final Logger LOG = LoggerFactory.getLogger(XMLDataLoader.class);
    private static final String RECORD_POSITION = "recordPosition";

    @Override
    public Map<String, List<Map<String, Object>>> loadData(String[] filePaths) {
        HashMap<String, List<Map<String, Object>>> result = new HashMap();
        try {
            result = this.loadXMLData(Arrays.asList(filePaths));
        }
        catch (IOException e) {
            Assert.fail((String)("An I/O exception occured while reading the files from the path :" + filePaths.toString()));
        }
        return result;
    }

    private Map<String, List<Map<String, Object>>> loadXMLData(List<String> dataFiles) throws IOException {
        Map<String, List<Map<String, Object>>> data = null;
        HashMap<String, List<Map<String, Object>>> finalData = new HashMap<String, List<Map<String, Object>>>();
        for (String filePath : dataFiles) {
            try {
                ResourceLoader resource = new ResourceLoader(filePath);
                data = this.load(resource.getInputStream());
            }
            catch (FileNotFoundException e) {
                LOG.error("The specified file was not found. The path is : {}", (Object)filePath);
                LOG.error("Continuing with the loading of next file.");
                continue;
            }
            catch (IOException e) {
                LOG.error("IO Exception occured while trying to read the data from the file : {}", (Object)filePath);
                LOG.error("Continuing with the loading of next file.");
                continue;
            }
            finalData.putAll(data);
        }
        return finalData;
    }

    private Map<String, List<Map<String, Object>>> load(InputStream xmlFile) throws IOException {
        HashMap<String, List<Map<String, Object>>> data = new HashMap<String, List<Map<String, Object>>>();
        JAXBContext context = this.getJAXBContext();
        try {
            if (context != null) {
                Unmarshaller unmarshaller = context.createUnmarshaller();
                InputTestData testData = (InputTestData)unmarshaller.unmarshal(xmlFile);
                this.convertFromInputTestData(testData, data);
            }
        }
        catch (JAXBException e) {
            LOG.error("JAXBException occured while trying to unmarshal the data.", (Throwable)e);
            throw new RuntimeException("JAXBException occured while trying to unmarshal the data.", e);
        }
        return data;
    }

    private void convertFromInputTestData(InputTestData source, Map<String, List<Map<String, Object>>> destination) {
        List<TestMethod> testMethods = source.getTestMethod();
        for (TestMethod method : testMethods) {
            List<Map<String, Object>> testMethodData = this.convertFromLIstOfTestRecords(method.getTestRecord());
            destination.put(method.getName(), testMethodData);
        }
    }

    private List<Map<String, Object>> convertFromLIstOfTestRecords(List<TestRecord> dataRecords) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (dataRecords != null) {
            for (TestRecord record : dataRecords) {
                Map<String, Object> singleTestData = this.convertFromListOfEntry(record.getInputData().getEntry());
                result.add(singleTestData);
            }
        }
        return result;
    }

    Map<String, Object> convertFromListOfEntry(List<Entry> testEntry) {
        HashMap<String, Object> testData = new HashMap<String, Object>();
        if (testEntry != null) {
            for (Entry entry : testEntry) {
                testData.put(entry.getKey(), entry.getValue());
            }
        }
        return testData;
    }

    private JAXBContext getJAXBContext() {
        JAXBContext context = null;
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            LOG.error("Error occured while creating JAXB COntext.", (Throwable)e);
        }
        return context;
    }

    @Override
    public void writeData(String filePath, Map<String, List<Map<String, Object>>> actualData) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            ResourceLoader resource = new ResourceLoader(filePath);
            Document document = db.parse(resource.getInputStream());
            Binder binder = this.getJAXBContext().createBinder();
            binder.setProperty("jaxb.formatted.output", (Object)true);
            InputTestData testData = (InputTestData)binder.unmarshal((Object)document);
            this.updateTestMethods(testData, actualData);
            binder.updateXML((Object)testData);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.transform(new DOMSource(document), new StreamResult(resource.getFileOutputStream()));
        }
        catch (ParserConfigurationException e) {
            LOG.error("Ignoring the write operation as ParserConfigurationException occured while parsing the file : " + filePath, (Throwable)e);
        }
        catch (SAXException e) {
            LOG.error("Ignoring the write operation as SAXException occured while parsing the file : " + filePath, (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Ignoring the write operation as IOException occured while parsing the file : " + filePath, (Throwable)e);
        }
        catch (JAXBException e) {
            LOG.error("Ignoring the write operation as JAXBException occured while parsing the file : " + filePath, (Throwable)e);
        }
        catch (TransformerException e) {
            LOG.error("Ignoring the write operation as TransformerException occured while parsing the file : " + filePath, (Throwable)e);
        }
    }

    private void updateTestMethods(InputTestData inputTestData, Map<String, List<Map<String, Object>>> actualData) {
        for (String methodName : actualData.keySet()) {
            List<Map<String, Object>> testRecords = actualData.get(methodName);
            block1: for (Map<String, Object> testRecord : testRecords) {
                Boolean outputDataAdded = false;
                if (!testRecord.containsKey("ActualResult")) continue;
                for (TestMethod testMethod : inputTestData.getTestMethod()) {
                    List<TestRecord> originalTestRecords = testMethod.getTestRecord();
                    for (TestRecord originalTestRecord : originalTestRecords) {
                        if (!originalTestRecord.getId().equals(testRecord.get(RECORD_POSITION))) continue;
                        OutputData outputData = new OutputData();
                        Entry outputEntry = new Entry();
                        outputEntry.setKey("ActualResult");
                        outputEntry.setValue(testRecord.get("ActualResult").toString());
                        outputData.getEntry().add(outputEntry);
                        originalTestRecord.setOutputData(outputData);
                        outputDataAdded = true;
                        break;
                    }
                    if (!outputDataAdded.booleanValue()) continue;
                    continue block1;
                }
            }
        }
    }
}

