/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataContext {
    public static final ThreadLocal<Map<String, List<Map<String, Object>>>> convertedDataThreadLocal = new ThreadLocal();
    public static final ThreadLocal<Map<String, List<Map<String, Object>>>> dataContextThreadLocal = new ThreadLocal();
    public static final ThreadLocal<String> nameContextThreadLocal = new ThreadLocal();

    private DataContext() {
    }

    public static void setData(Map<String, List<Map<String, Object>>> data) {
        Map<String, List<Map<String, Object>>> testData = dataContextThreadLocal.get();
        if (testData == null || testData.isEmpty()) {
            dataContextThreadLocal.set(data);
        } else {
            for (String key : data.keySet()) {
                testData.put(key, data.get(key));
            }
            dataContextThreadLocal.set(testData);
        }
    }

    public static void setConvertedData(Map<String, List<Map<String, Object>>> data) {
        Map<String, List<Map<String, Object>>> testData = convertedDataThreadLocal.get();
        if (testData == null || testData.isEmpty()) {
            convertedDataThreadLocal.set(data);
        } else {
            boolean removedOldKeys = false;
            for (String key : data.keySet()) {
                if (!removedOldKeys) {
                    String newKeyMethod = key.substring(0, key.indexOf("{"));
                    Iterator<Map.Entry<String, List<Map<String, Object>>>> testDataItr = testData.entrySet().iterator();
                    while (testDataItr.hasNext()) {
                        Map.Entry<String, List<Map<String, Object>>> entry = testDataItr.next();
                        String oldKey = entry.getKey();
                        String oldKeyMethod = oldKey.substring(0, oldKey.indexOf("{"));
                        if (oldKeyMethod.equals(newKeyMethod)) {
                            testDataItr.remove();
                        }
                        removedOldKeys = true;
                    }
                }
                testData.put(key, data.get(key));
            }
            convertedDataThreadLocal.set(testData);
        }
    }

    public static Map<String, List<Map<String, Object>>> getConvertedData() {
        return convertedDataThreadLocal.get();
    }

    public static Map<String, List<Map<String, Object>>> getData() {
        return dataContextThreadLocal.get();
    }

    public static void clearData() {
        dataContextThreadLocal.remove();
    }

    public static void clearConvertedData() {
        convertedDataThreadLocal.remove();
    }

    public static String getMethodName() {
        return nameContextThreadLocal.get();
    }

    public static void setMethodName(String name) {
        nameContextThreadLocal.set(name);
    }

    public static void clearNameData() {
        nameContextThreadLocal.remove();
    }
}

