/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLoader {
    protected static final Logger LOG = LoggerFactory.getLogger(ResourceLoader.class);
    private String filePath;
    private ClassLoader classLoader;

    public ResourceLoader(String filePath, ClassLoader classLoader) {
        this.filePath = filePath;
        this.classLoader = classLoader;
    }

    public ResourceLoader(String filePath) {
        this.filePath = filePath;
        this.classLoader = null;
    }

    public InputStream getInputStream() throws IOException {
        FileInputStream is = null;
        ClassLoader classLoader = this.classLoader;
        if (this.classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        URL resource = classLoader.getResource(this.filePath);
        String path = null;
        if (resource != null) {
            path = resource.getPath();
        }
        LOG.debug("getInputStream() File absolute path:" + path);
        if (path == null) {
            throw new FileNotFoundException(this.filePath + " cannot be opened because it does not exist");
        }
        is = new FileInputStream(path);
        return is;
    }

    public FileOutputStream getFileOutputStream() throws IOException {
        FileOutputStream fos = null;
        ClassLoader classLoader = this.classLoader;
        if (this.classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        String path = classLoader.getResource(this.filePath).getPath();
        LOG.debug("getFileOutputStream File absolute path:" + path);
        if (path == null) {
            throw new FileNotFoundException(this.filePath + " cannot be opened because it does not exist");
        }
        fos = new FileOutputStream(path);
        return fos;
    }
}

