/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.easetech.easytest.loader.Loader;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunAftersWithOutputData
extends Statement {
    protected static final Logger LOG = LoggerFactory.getLogger(RunAftersWithOutputData.class);
    private final Loader loader;
    private final String[] filePath;
    private Map<String, List<Map<String, Object>>> writableData;
    private final Statement fNext;
    private final Object fTarget;
    private final List<FrameworkMethod> fAfters;

    public RunAftersWithOutputData(Statement next, List<FrameworkMethod> afters, Object target, Loader loader, String[] filePath, Map<String, List<Map<String, Object>>> writableData) {
        this.fNext = next;
        this.fAfters = afters;
        this.fTarget = target;
        this.loader = loader;
        this.filePath = filePath;
        this.writableData = writableData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate() throws Throwable {
        LOG.info("evaluate started");
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            this.fNext.evaluate();
        }
        catch (Throwable e) {
            errors.add(e);
        }
        finally {
            for (FrameworkMethod each : this.fAfters) {
                try {
                    each.invokeExplosively(this.fTarget, new Object[0]);
                }
                catch (Throwable e) {
                    errors.add(e);
                }
            }
        }
        MultipleFailureException.assertEmpty(errors);
        if (this.loader != null && this.filePath.length > 0) {
            LOG.debug("Loader:" + this.loader + ", filePath:" + this.filePath[0]);
            LOG.debug("writableData:" + this.writableData);
            this.loader.writeData(this.filePath[0], this.writableData);
        }
        LOG.info("evaluate finished");
    }
}

