/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.integration.apache.common.csv;

import java.beans.IntrospectionException;
import java.io.StringWriter;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.easybatch.core.api.RecordFieldExtractor;
import org.easybatch.core.api.RecordMarshallingException;
import org.easybatch.core.field.BeanRecordFieldExtractor;
import org.easybatch.core.processor.AbstractRecordMarshaller;

public class ApacheCommonCsvRecordMarshaller
extends AbstractRecordMarshaller {
    private final RecordFieldExtractor fieldExtractor;
    private CSVFormat csvFormat;

    public ApacheCommonCsvRecordMarshaller(Class type, String[] fields, CSVFormat csvFormat) throws IntrospectionException {
        this((RecordFieldExtractor)new BeanRecordFieldExtractor(type, fields), csvFormat);
    }

    public ApacheCommonCsvRecordMarshaller(RecordFieldExtractor fieldExtractor, CSVFormat csvFormat) throws IntrospectionException {
        this.fieldExtractor = fieldExtractor;
        this.csvFormat = csvFormat;
    }

    protected String marshal(Object record) throws RecordMarshallingException {
        try {
            StringWriter stringWriter = new StringWriter();
            CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, this.csvFormat.withRecordSeparator(null));
            Iterable iterable = this.fieldExtractor.extractFields(record);
            csvPrinter.printRecord(iterable);
            csvPrinter.flush();
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new RecordMarshallingException((Throwable)e);
        }
    }
}

