/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.extensions.apache.common.csv;

import java.beans.IntrospectionException;
import java.io.StringWriter;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;
import org.easybatch.core.field.BeanFieldExtractor;
import org.easybatch.core.field.FieldExtractor;
import org.easybatch.core.marshaller.RecordMarshaller;
import org.easybatch.core.record.Record;
import org.easybatch.core.record.StringRecord;

public class ApacheCommonCsvRecordMarshaller<P>
implements RecordMarshaller<Record<P>, StringRecord> {
    public static final char DEFAULT_DELIMITER = ',';
    public static final char DEFAULT_QUALIFIER = '\"';
    private final FieldExtractor<P> fieldExtractor;
    private CSVFormat csvFormat;

    public ApacheCommonCsvRecordMarshaller(Class<P> type, String ... fields) throws IntrospectionException {
        this(type, fields, ',', '\"');
    }

    public ApacheCommonCsvRecordMarshaller(Class<P> type, String[] fields, char delimiter) throws IntrospectionException {
        this(type, fields, delimiter, '\"');
    }

    public ApacheCommonCsvRecordMarshaller(Class<P> type, String[] fields, char delimiter, char qualifier) throws IntrospectionException {
        this((FieldExtractor<P>)new BeanFieldExtractor(type, fields), delimiter, qualifier);
    }

    public ApacheCommonCsvRecordMarshaller(FieldExtractor<P> fieldExtractor, char delimiter, char qualifier) throws IntrospectionException {
        this.fieldExtractor = fieldExtractor;
        this.csvFormat = CSVFormat.newFormat((char)delimiter).withQuote(qualifier).withQuoteMode(QuoteMode.ALL).withRecordSeparator(null);
    }

    public StringRecord processRecord(Record<P> record) throws Exception {
        StringWriter stringWriter = new StringWriter();
        CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, this.csvFormat);
        Iterable iterable = this.fieldExtractor.extractFields(record.getPayload());
        csvPrinter.printRecord(iterable);
        csvPrinter.flush();
        return new StringRecord(record.getHeader(), stringWriter.toString());
    }
}

