/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.extensions.apache.common.csv;

import java.util.Date;
import java.util.Iterator;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.easybatch.core.reader.RecordReader;
import org.easybatch.core.record.Header;
import org.easybatch.core.util.Utils;
import org.easybatch.extensions.apache.common.csv.ApacheCommonCsvRecord;

public class ApacheCommonCsvRecordReader
implements RecordReader {
    private CSVParser parser;
    private Iterator<CSVRecord> iterator;

    public ApacheCommonCsvRecordReader(CSVParser parser) {
        Utils.checkNotNull((Object)parser, (String)"csv parser");
        this.parser = parser;
    }

    public void open() {
        this.iterator = this.parser.iterator();
    }

    public ApacheCommonCsvRecord readRecord() {
        if (this.iterator.hasNext()) {
            Header header = new Header(Long.valueOf(this.parser.getRecordNumber()), this.getDataSourceName(), new Date());
            return new ApacheCommonCsvRecord(header, this.iterator.next());
        }
        return null;
    }

    private String getDataSourceName() {
        return this.parser.toString();
    }

    public void close() throws Exception {
        this.parser.close();
    }
}

