/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.tools.reporting;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.easybatch.core.job.DefaultJobReportFormatter;
import org.easybatch.core.job.JobParameters;
import org.easybatch.core.job.JobReport;
import org.easybatch.core.job.JobReportFormatter;
import org.easybatch.core.listener.JobListener;
import org.easybatch.core.util.Utils;

@Deprecated
public class JobReportEmailSender
implements JobListener {
    public static final String USER = "org.easybatch.tools.reporting.email.user";
    public static final String PASSWORD = "org.easybatch.tools.reporting.email.password";
    public static final String SENDER = "org.easybatch.tools.reporting.email.sender";
    public static final String RECIPIENT = "org.easybatch.tools.reporting.email.recipient";
    public static final String SUBJECT = "org.easybatch.tools.reporting.email.subject";
    private Properties properties;
    private EmailSender messageSender;
    private JobReportFormatter<String> jobReportFormatter;

    public JobReportEmailSender(Properties properties) {
        this.validate(properties);
        this.properties = properties;
        this.messageSender = new EmailSender();
        this.jobReportFormatter = new DefaultJobReportFormatter();
    }

    public void setJobReportFormatter(JobReportFormatter<String> jobReportFormatter) {
        Utils.checkNotNull(jobReportFormatter, (String)"job report formatter");
        this.jobReportFormatter = jobReportFormatter;
    }

    JobReportEmailSender(Properties properties, EmailSender emailSender) {
        this.validate(properties);
        this.properties = properties;
        this.messageSender = emailSender;
    }

    public void beforeJobStart(JobParameters jobParameters) {
    }

    public void afterJobEnd(JobReport jobReport) {
        String formattedJobReport = this.format(jobReport);
        this.send(formattedJobReport);
    }

    private String format(JobReport jobReport) {
        return (String)this.jobReportFormatter.formatReport(jobReport);
    }

    private void send(String formattedJobReport) {
        Session session = Session.getInstance((Properties)this.properties, (Authenticator)this.getAuthenticator());
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(this.properties.getProperty(SENDER)));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.properties.getProperty(RECIPIENT)));
            message.setSubject(this.properties.getProperty(SUBJECT));
            message.setText(formattedJobReport);
            this.messageSender.send((Message)message);
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unable to send job report by email", e);
        }
    }

    private Authenticator getAuthenticator() {
        final String username = this.properties.getProperty(USER);
        final String password = this.properties.getProperty(PASSWORD);
        return new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        };
    }

    private void validate(Properties properties) {
        this.check(properties, USER);
        this.check(properties, PASSWORD);
        this.check(properties, SENDER);
        this.check(properties, RECIPIENT);
        this.check(properties, SUBJECT);
    }

    private void check(Properties properties, String property) {
        if (properties.getProperty(property) == null) {
            throw new IllegalArgumentException(String.format("Property %s is mandatory", property));
        }
    }

    class EmailSender {
        EmailSender() {
        }

        void send(Message message) throws MessagingException {
            Transport.send((Message)message);
        }
    }
}

