/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.classextension.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.easymock.classextension.ConstructorArgs;
import org.easymock.classextension.EasyMock;
import org.easymock.classextension.EasyMockSupport;
import org.easymock.classextension.IMockBuilder;
import org.easymock.classextension.IMocksControl;
import org.easymock.classextension.internal.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockBuilder<T>
implements IMockBuilder<T> {
    private final Class<T> toMock;
    private final Set<Method> mockedMethods = new HashSet<Method>();
    private Constructor<T> constructor;
    private ConstructorArgs constructorArgs;
    private final EasyMockSupport support;

    public MockBuilder(Class<T> toMock) {
        this(toMock, null);
    }

    public MockBuilder(Class<T> toMock, EasyMockSupport support) {
        this.toMock = toMock;
        this.support = support;
    }

    @Override
    public IMockBuilder<T> addMockedMethod(Method method) {
        this.mockedMethods.add(method);
        return this;
    }

    @Override
    public IMockBuilder<T> addMockedMethod(String methodName) {
        Method m = ReflectionUtils.findMethod(this.toMock, methodName);
        if (m == null) {
            throw new IllegalArgumentException("Method not found (or private): " + methodName);
        }
        this.mockedMethods.add(m);
        return this;
    }

    @Override
    public IMockBuilder<T> addMockedMethod(String methodName, Class<?> ... parameterTypes) {
        Method m = ReflectionUtils.findMethod(this.toMock, methodName, parameterTypes);
        if (m == null) {
            throw new IllegalArgumentException("Method not found (or private): " + methodName);
        }
        this.mockedMethods.add(m);
        return this;
    }

    @Override
    public IMockBuilder<T> addMockedMethods(String ... methodNames) {
        for (String methodName : methodNames) {
            this.addMockedMethod(methodName);
        }
        return this;
    }

    @Override
    public IMockBuilder<T> addMockedMethods(Method ... methods) {
        for (Method method : methods) {
            this.addMockedMethod(method);
        }
        return this;
    }

    @Override
    public IMockBuilder<T> withConstructor(Constructor<?> constructor) {
        this.checkConstructorNotInitialized();
        this.constructor = constructor;
        return this;
    }

    @Override
    public IMockBuilder<T> withConstructor(ConstructorArgs constructorArgs) {
        this.checkConstructorNotInitialized();
        this.constructor = constructorArgs.getConstructor();
        this.constructorArgs = constructorArgs;
        return this;
    }

    @Override
    public IMockBuilder<T> withConstructor() {
        this.checkConstructorNotInitialized();
        try {
            this.constructor = ReflectionUtils.getConstructor(this.toMock, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No empty constructor can be found", e);
        }
        this.constructorArgs = new ConstructorArgs(this.constructor, new Object[0]);
        return this;
    }

    @Override
    public IMockBuilder<T> withConstructor(Object ... initArgs) {
        this.checkConstructorNotInitialized();
        try {
            this.constructor = ReflectionUtils.getConstructor(this.toMock, initArgs);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No constructor matching arguments can be found", e);
        }
        this.constructorArgs = new ConstructorArgs(this.constructor, initArgs);
        return this;
    }

    @Override
    public IMockBuilder<T> withConstructor(Class<?> ... argTypes) {
        this.checkConstructorNotInitialized();
        try {
            this.constructor = this.toMock.getDeclaredConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No constructor matching arguments can be found", e);
        }
        return this;
    }

    @Override
    public IMockBuilder<T> withArgs(Object ... initArgs) {
        if (this.constructor == null) {
            throw new IllegalStateException("Trying to define constructor arguments without first setting their type.");
        }
        if (this.constructorArgs != null) {
            throw new IllegalStateException("Trying to define the constructor arguments more than once.");
        }
        this.constructorArgs = new ConstructorArgs(this.constructor, initArgs);
        return this;
    }

    @Override
    public T createMock(IMocksControl control) {
        return this.createMock(null, control);
    }

    @Override
    public T createMock() {
        return this.createMock((String)null);
    }

    @Override
    public T createNiceMock() {
        return this.createNiceMock(null);
    }

    @Override
    public T createStrictMock() {
        return this.createStrictMock(null);
    }

    @Override
    public T createMock(String name, IMocksControl control) {
        if (this.constructor == null) {
            return control.createMock(name, this.toMock, this.mockedMethods.toArray(new Method[this.mockedMethods.size()]));
        }
        if (this.constructorArgs == null) {
            throw new IllegalStateException("Picked a constructor but didn't pass arguments to it");
        }
        return control.createMock(name, this.toMock, this.constructorArgs, this.mockedMethods.toArray(new Method[this.mockedMethods.size()]));
    }

    @Override
    public T createMock(String name) {
        IMocksControl control = this.support == null ? EasyMock.createControl() : this.support.createControl();
        return this.createMock(name, control);
    }

    @Override
    public T createNiceMock(String name) {
        IMocksControl control = this.support == null ? EasyMock.createNiceControl() : this.support.createNiceControl();
        return this.createMock(name, control);
    }

    @Override
    public T createStrictMock(String name) {
        IMocksControl control = this.support == null ? EasyMock.createStrictControl() : this.support.createStrictControl();
        return this.createMock(name, control);
    }

    private void checkConstructorNotInitialized() {
        if (this.constructor != null) {
            throw new IllegalStateException("Trying to define the constructor call more than once.");
        }
    }
}

