/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.agent;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.LocalDateTime;
import org.easypeelsecurity.springdog.agent.ResponseStatus;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;

public class CommonResponse<T> {
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private final LocalDateTime timestamp = LocalDateTime.now();
    private final T detail;
    private final String message;
    private final ResponseStatus result;

    public CommonResponse(T detail, String message, ResponseStatus result) {
        this.detail = detail;
        this.message = message;
        this.result = result;
    }

    public CommonResponse(T detail) {
        this(detail, "The request was successfully processed.", ResponseStatus.SUCCESS);
    }

    public static <T> ResponseEntity<CommonResponse<T>> responseError(String message) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(new CommonResponse<Object>(null, message, ResponseStatus.FAILURE));
    }

    public static <T> ResponseEntity<CommonResponse<T>> responseError(String message, Exception e) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(new CommonResponse<Object>(null, message + " " + e.getLocalizedMessage(), ResponseStatus.FAILURE));
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public T getDetail() {
        return this.detail;
    }

    public String getMessage() {
        return this.message;
    }

    public String getResult() {
        return this.result.name();
    }
}

