/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.agent;

import org.easypeelsecurity.springdog.agent.CommonResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;

abstract class SpringdogAPIExceptionHandler {
    SpringdogAPIExceptionHandler() {
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MethodArgumentNotValidException.class, IllegalArgumentException.class, HttpMessageNotReadableException.class})
    protected ResponseEntity<CommonResponse<Void>> handleInvalidInput(Exception e) {
        return CommonResponse.responseError("Invalid input value.", e);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={IllegalStateException.class})
    protected ResponseEntity<CommonResponse<Void>> handleIllegalStateException(IllegalStateException e) {
        return CommonResponse.responseError("This is an inappropriate call.", e);
    }
}

