/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.agent;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.easypeelsecurity.springdog.agent.SpringdogAgentController;
import org.easypeelsecurity.springdog.domain.errortracing.model.ExceptionListingService;
import org.easypeelsecurity.springdog.domain.ratelimit.EndpointService;
import org.easypeelsecurity.springdog.domain.statistics.StatisticsService;
import org.easypeelsecurity.springdog.shared.configuration.SpringdogProperties;
import org.easypeelsecurity.springdog.shared.dto.EndpointDto;
import org.easypeelsecurity.springdog.shared.settings.NotificationGlobalSetting;
import org.easypeelsecurity.springdog.shared.settings.SlowResponseSetting;
import org.easypeelsecurity.springdog.shared.settings.SpringdogSettingManagerImpl;
import org.easypeelsecurity.springdog.shared.settings.SystemWatchSetting;
import org.easypeelsecurity.springdog.shared.util.Assert;
import org.easypeelsecurity.springdog.shared.vo.DashboardResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;

@Controller
@SpringdogAgentController
public class SpringdogAgentView {
    SecurityContextLogoutHandler logoutHandler = new SecurityContextLogoutHandler();
    @Autowired
    private StatisticsService statisticsService;
    @Autowired
    private EndpointService endpointService;
    @Autowired
    private ExceptionListingService exceptionListingService;
    @Autowired
    private SpringdogProperties properties;
    @Autowired
    private SpringdogSettingManagerImpl settingManager;

    @GetMapping(value={"/login"})
    public String login() {
        return "/templates/content/login.html";
    }

    @GetMapping(value={"/logout"})
    public String performLogout(Authentication authentication, HttpServletRequest request, HttpServletResponse response) {
        this.logoutHandler.logout(request, response, authentication);
        return "redirect:" + this.properties.computeAbsolutePath("/login?logout");
    }

    @GetMapping(value={"/", ""})
    public String home(Model model) {
        model.addAttribute("endpointChangeLog", (Object)this.endpointService.getAllChangeLogsNotResolved());
        DashboardResponse dashboard = this.statisticsService.getDashboardResponse(LocalDate.now());
        model.addAttribute("totalEndpointCount", (Object)dashboard.totalEndpointCount());
        model.addAttribute("totalEndpointCountActive", (Object)dashboard.totalActiveEndpointCount());
        model.addAttribute("totalEndpointCountNotActive", (Object)dashboard.totalInactiveEndpointCount());
        model.addAttribute("recentSystemMetrics", (Object)dashboard.recentSystemMetrics());
        model.addAttribute("recentEndpointMetrics", (Object)dashboard.dailyEndpointMetrics());
        model.addAttribute("dailyTopTraffic", (Object)dashboard.dailyTopTrafficEndpoints());
        model.addAttribute("dailyTopFailure", (Object)dashboard.dailyTopFailEndpoints());
        model.addAttribute("dailySlowestEndpoints", (Object)dashboard.dailySlowestEndpoints());
        return "/templates/content/main.html";
    }

    @GetMapping(value={"/rate-limit"})
    public String rateLimitManage(Model model) {
        List endpoints = this.endpointService.findAllEndpoints();
        model.addAttribute("endpoints", (Object)endpoints);
        return "/templates/content/rate-limit/manage.html";
    }

    @GetMapping(value={"/rate-limit/{endpointId}"})
    public String viewRateLimitSpecific(@PathVariable(name="endpointId") long endpointId, Model model) {
        EndpointDto endpointDto = this.endpointService.findEndpoint(endpointId);
        model.addAttribute("endpoint", (Object)endpointDto);
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("X-Auth-Token");
        model.addAttribute("headerItems", headers);
        return "/templates/content/rate-limit/actions/setting.html";
    }

    @GetMapping(value={"/rate-limit/{endpointId}/analytics"})
    public String viewRateLimitSpecificAnalytics(@PathVariable(name="endpointId") long endpointId, Model model) {
        EndpointDto endpointDto = this.endpointService.findEndpoint(endpointId);
        model.addAttribute("endpoint", (Object)endpointDto);
        model.addAttribute("statics", (Object)this.statisticsService.getRecentEndpointMetric(endpointId, 10));
        return "/templates/content/rate-limit/actions/analytics.html";
    }

    @PostMapping(value={"/rate-limit/{endpointId}"})
    public String modifyRateLimit(@PathVariable(name="endpointId") long endpointId, @ModelAttribute(value="endpoint") EndpointDto endpointDto, Model model) {
        try {
            Assert.isEqual((Object)endpointId, (Object)endpointDto.getId(), (String)"Invalid request");
            this.endpointService.updateRule(endpointDto);
        }
        catch (Exception e) {
            model.addAttribute("result", (Object)false);
            model.addAttribute("message", (Object)e.getMessage());
            return this.viewRateLimitSpecific(endpointId, model);
        }
        model.addAttribute("result", (Object)true);
        model.addAttribute("message", (Object)"Successfully updated");
        return this.viewRateLimitSpecific(endpointId, model);
    }

    @GetMapping(value={"/notification"})
    public String notificationSettingView(Model model) {
        model.addAttribute("mailConfiguration", (Object)this.settingManager.getSettings().getNotificationGlobalSetting());
        return "/templates/content/notification/configuration.html";
    }

    @PostMapping(value={"/notification"})
    public String notificationSettingUpdate(Model model, @ModelAttribute(value="mailConfiguration") NotificationGlobalSetting newSetting) {
        try {
            this.settingManager.updateNotificationGlobalSetting(newSetting);
        }
        catch (Exception e) {
            model.addAttribute("result", (Object)false);
            model.addAttribute("message", (Object)e.getMessage());
            return this.notificationSettingView(model);
        }
        model.addAttribute("result", (Object)true);
        model.addAttribute("message", (Object)"Successfully updated");
        return this.notificationSettingView(model);
    }

    @GetMapping(value={"/notification/system-watch"})
    public String notificationSystemWatchView(Model model) {
        model.addAttribute("systemWatchConfiguration", (Object)this.settingManager.getSettings().getSystemWatchSetting());
        return "/templates/content/notification/system-watch.html";
    }

    @PostMapping(value={"/notification/system-watch"})
    public String notificationSystemWatchSettingUpdate(Model model, @ModelAttribute(value="systemWatchConfiguration") SystemWatchSetting newSetting) {
        try {
            this.settingManager.updateSystemWatchSetting(newSetting);
        }
        catch (Exception e) {
            model.addAttribute("result", (Object)false);
            model.addAttribute("message", (Object)e.getMessage());
            return this.notificationSystemWatchView(model);
        }
        model.addAttribute("result", (Object)true);
        model.addAttribute("message", (Object)"Successfully updated");
        return this.notificationSystemWatchView(model);
    }

    @GetMapping(value={"/notification/slow-response"})
    public String notificationSlowResponseView(Model model) {
        model.addAttribute("slowResponseConfiguration", (Object)this.settingManager.getSettings().getSlowResponseSetting());
        return "/templates/content/notification/slow-response.html";
    }

    @PostMapping(value={"/notification/slow-response"})
    public String notificationSlowResponseSettingUpdate(Model model, @ModelAttribute(value="slowResponseConfiguration") SlowResponseSetting newSetting) {
        try {
            this.settingManager.updateSlowResponseSetting(newSetting);
        }
        catch (Exception e) {
            model.addAttribute("result", (Object)false);
            model.addAttribute("message", (Object)e.getMessage());
            return this.notificationSlowResponseView(model);
        }
        model.addAttribute("result", (Object)true);
        model.addAttribute("message", (Object)"Successfully updated");
        return this.notificationSlowResponseView(model);
    }

    @GetMapping(value={"/error-tracing"})
    public String errorTracingHome(Model model) {
        List causes = this.exceptionListingService.getAllParentCauses();
        model.addAttribute("causes", (Object)causes);
        return "/templates/content/error-tracing/list.html";
    }

    @GetMapping(value={"/error-tracing/configuration"})
    public String errorTracingConfiguration(Model model) {
        model.addAttribute("exceptionClasses", (Object)this.exceptionListingService.getExceptionListing());
        return "/templates/content/error-tracing/configuration.html";
    }

    @GetMapping(value={"/system-watch"})
    public String systemWatchView(Model model) {
        model.addAttribute("systemMetrics", (Object)this.statisticsService.getRecentSystemMetrics(50));
        return "/templates/content/system-watch/metrics.html";
    }

    @GetMapping(value={"/service/change-pw"})
    public String changePW() {
        return "/templates/content/service/change-pw.html";
    }
}

