/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.agent.security;

import org.easypeelsecurity.springdog.shared.configuration.SpringdogProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
public class SpringdogSecurityConfig {
    public static final String SPRINGDOG_AGENT_ADMIN_ROLE = "SPRINGDOG_AGENT_ADMIN";
    private final SpringdogProperties springdogProperties;

    public SpringdogSecurityConfig(SpringdogProperties springdogProperties) {
        this.springdogProperties = springdogProperties;
    }

    @Bean
    @Order(value=-2147483648)
    public SecurityFilterChain springdogSecurityFilterChain(HttpSecurity http) throws Exception {
        String baseAbsolutePath = this.springdogProperties.computeAbsolutePath("");
        http.securityMatcher(new String[]{baseAbsolutePath + "**"}).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).hasRole(SPRINGDOG_AGENT_ADMIN_ROLE)).formLogin(formLogin -> ((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)formLogin.loginPage(this.springdogProperties.computeAbsolutePath("/login")).failureUrl(this.springdogProperties.computeAbsolutePath("/login?error"))).loginProcessingUrl(this.springdogProperties.computeAbsolutePath("/login"))).defaultSuccessUrl(this.springdogProperties.computeAbsolutePath("/"))).permitAll()).logout(logout -> logout.logoutUrl(this.springdogProperties.computeAbsolutePath("/logout")).logoutSuccessUrl(this.springdogProperties.computeAbsolutePath("/login?logout")).permitAll()).csrf(AbstractHttpConfigurer::disable);
        return (SecurityFilterChain)http.build();
    }

    @Bean(value={"springdogAuthenticationManager"})
    public AuthenticationManager springdogAuthenticationManager(HttpSecurity http) {
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService(this.springdogUserDetailsService());
        return new ProviderManager(new AuthenticationProvider[]{provider});
    }

    public UserDetailsService springdogUserDetailsService() {
        String username = this.springdogProperties.getAgentUsername();
        String password = this.springdogProperties.getAgentPassword();
        UserDetails user = User.withUsername((String)username).password("{noop}" + password).roles(new String[]{SPRINGDOG_AGENT_ADMIN_ROLE}).build();
        return new InMemoryUserDetailsManager(new UserDetails[]{user});
    }
}

