/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.autoconfigure.applier;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import org.easypeelsecurity.springdog.autoconfigure.applier.CodeGenerator;
import org.easypeelsecurity.springdog.autoconfigure.applier.SpringDogEnable;
import org.easypeelsecurity.springdog.autoconfigure.applier.SpringdogAgentApplier;
import org.easypeelsecurity.springdog.autoconfigure.applier.SpringdogAutoConfigurationApplier;
import org.easypeelsecurity.springdog.autoconfigure.applier.SpringdogBannerPrinter;
import org.easypeelsecurity.springdog.autoconfigure.applier.SpringdogDomainApplier;
import org.easypeelsecurity.springdog.autoconfigure.applier.SpringdogDynamicTemplateResolver;
import org.easypeelsecurity.springdog.autoconfigure.applier.SpringdogManagerApplier;
import org.easypeelsecurity.springdog.autoconfigure.applier.SpringdogNotificationApplier;
import org.easypeelsecurity.springdog.autoconfigure.applier.SpringdogSharedApplier;
import org.easypeelsecurity.springdog.autoconfigure.applier.SpringdogStorageApplier;

public class SpringDogEnableProcessor
extends AbstractProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(SpringDogEnable.class.getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver() && !annotations.isEmpty()) {
            this.generateConfigurations(roundEnv);
            return true;
        }
        return false;
    }

    private void generateConfigurations(RoundEnvironment roundEnv) {
        roundEnv.getElementsAnnotatedWith(SpringDogEnable.class).forEach(element -> {
            String fullPackageName = element.getEnclosingElement().toString();
            List<CodeGenerator> generatedCodes = Arrays.asList(new SpringdogStorageApplier(), new SpringdogDynamicTemplateResolver(), new SpringdogBannerPrinter(), new SpringdogManagerApplier(), new SpringdogAutoConfigurationApplier(), new SpringdogSharedApplier(), new SpringdogNotificationApplier(), new SpringdogDomainApplier(), new SpringdogAgentApplier());
            generatedCodes.forEach(generator -> generator.writeTo(fullPackageName, this.processingEnv));
        });
    }
}

