/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.autoconfigure.controller.parser;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.springframework.web.bind.annotation.RequestParam;

abstract class ParameterNameExtractor {
    ParameterNameExtractor() {
    }

    private static Map<String, String[]> getMethodParameterNames(Class<?> clazz) throws IOException {
        HashMap<String, String[]> methodParamNames = new HashMap<String, String[]>();
        ClassReader classReader = new ClassReader(clazz.getName());
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        List methods = classNode.methods;
        for (MethodNode method : methods) {
            final String[] paramNames = new String[Type.getArgumentTypes((String)method.desc).length];
            methodParamNames.put(method.name + method.desc, paramNames);
            method.accept(new MethodVisitor(589824){

                public AnnotationVisitor visitParameterAnnotation(final int parameter, String descriptor, boolean visible) {
                    if (descriptor.equals(Type.getDescriptor(RequestParam.class))) {
                        return new AnnotationVisitor(589824){

                            public void visit(String name, Object value) {
                                if ("value".equals(name)) {
                                    paramNames[parameter] = (String)value;
                                }
                            }
                        };
                    }
                    return super.visitParameterAnnotation(parameter, descriptor, visible);
                }

                public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                    int paramIndex = index - 1;
                    if (paramIndex >= 0 && paramIndex < paramNames.length && paramNames[paramIndex] == null) {
                        paramNames[paramIndex] = name;
                    }
                }
            });
        }
        return methodParamNames;
    }

    public static String[] getParameterNames(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws IOException, NoSuchMethodException {
        Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
        String key = method.getName() + Type.getMethodDescriptor((Method)method);
        Map<String, String[]> paramMap = ParameterNameExtractor.getMethodParameterNames(clazz);
        return paramMap.get(key);
    }
}

