/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.domain.errortracing.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.easypeelsecurity.springdog.domain.errortracing.model.ExceptionCause;
import org.easypeelsecurity.springdog.domain.errortracing.model.ExceptionClass;
import org.easypeelsecurity.springdog.domain.errortracing.model.ExceptionListingRepository;
import org.easypeelsecurity.springdog.domain.errortracing.model.ExceptionType;
import org.easypeelsecurity.springdog.domain.errortracing.model.converter.ExceptionConverter;
import org.easypeelsecurity.springdog.shared.dto.ErrorTracingDto;
import org.easypeelsecurity.springdog.shared.dto.ExceptionClassesDto;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ExceptionListingService {
    private final ObjectContext context;
    private final ExceptionListingRepository exceptionRepository;

    public ExceptionListingService(@Qualifier(value="springdogContext") ObjectContext context, ExceptionListingRepository exceptionRepository) {
        this.context = context;
        this.exceptionRepository = exceptionRepository;
    }

    public void saveExceptionsWithoutDuplicate(ExceptionClassesDto parsedList) {
        ArrayList<ExceptionType> existingTypes = new ArrayList<ExceptionType>(this.exceptionRepository.findAllExceptions(this.context));
        for (ExceptionClassesDto.ExceptionListDto newListDto : parsedList.exceptionList()) {
            ExceptionType existingType = this.findExistingType(existingTypes, newListDto.packageType());
            if (existingType == null) {
                ExceptionType newType = (ExceptionType)((Object)this.context.newObject(ExceptionType.class));
                newType.setPackageType(newListDto.packageType());
                newType.setDescription(newListDto.description());
                this.updateExceptionClasses(newType, newListDto.subExceptions());
                continue;
            }
            existingType.setDescription(newListDto.description());
            this.updateExceptionClasses(existingType, newListDto.subExceptions());
            existingTypes.remove((Object)existingType);
        }
        for (ExceptionType typeToDelete : existingTypes) {
            for (ExceptionClass classToDelete : typeToDelete.getExceptionClasses()) {
                this.context.deleteObject((Object)classToDelete);
            }
            this.context.deleteObject((Object)typeToDelete);
        }
        this.context.commitChanges();
    }

    public void changeMonitoringStatus(long exceptionClassId, boolean isEnableToMonitor) {
        ExceptionClass exceptionClass = this.exceptionRepository.findExceptionClassByIdOrNull(this.context, exceptionClassId);
        if (exceptionClass == null) {
            throw new IllegalArgumentException("Exception class not found.");
        }
        exceptionClass.setMonitoringEnabled(isEnableToMonitor);
        this.context.commitChanges();
    }

    private ExceptionType findExistingType(List<ExceptionType> existingTypes, String packageType) {
        return existingTypes.stream().filter(type -> type.getPackageType().equals(packageType)).findFirst().orElse(null);
    }

    private void updateExceptionClasses(ExceptionType exceptionType, List<ExceptionClassesDto.ExceptionListDto.ExceptionItemDto> newExceptions) {
        ArrayList<ExceptionClass> existingClasses = new ArrayList<ExceptionClass>(exceptionType.getExceptionClasses());
        for (ExceptionClassesDto.ExceptionListDto.ExceptionItemDto newException : newExceptions) {
            ExceptionClass existingClass = this.findExistingClass(existingClasses, newException.exceptionName());
            if (existingClass == null) {
                ExceptionConverter.convertDtoToEntity(this.context, exceptionType, newException);
                continue;
            }
            existingClasses.remove((Object)existingClass);
        }
        for (ExceptionClass classToDelete : existingClasses) {
            this.context.deleteObject((Object)classToDelete);
        }
    }

    private ExceptionClass findExistingClass(List<ExceptionClass> existingClasses, String exceptionName) {
        return existingClasses.stream().filter(clazz -> clazz.getExceptionClassName().equals(exceptionName)).findFirst().orElse(null);
    }

    public ExceptionClassesDto getExceptionListing() {
        return ExceptionConverter.convertEntitiesToDto(this.exceptionRepository.findAllExceptions(this.context));
    }

    public boolean isExceptionEnabled(String exceptionFQCM) {
        ExceptionClass exceptionClass = this.exceptionRepository.findByExceptionClassByFQCM(this.context, exceptionFQCM);
        return exceptionClass != null && exceptionClass.isMonitoringEnabled();
    }

    public void saveException(ErrorTracingDto errorChain) {
        ExceptionCause exceptionCause = ExceptionConverter.convertDtoToEntity(this.context, errorChain);
        this.context.commitChanges();
    }

    public List<ErrorTracingDto> getAllParentCauses() {
        return ExceptionConverter.entityToErrorTracingDto(this.exceptionRepository.findAllParentExceptionCauses(this.context));
    }

    public ErrorTracingDto getErrorTrace(long errorTraceId) {
        ExceptionCause result = this.exceptionRepository.findExceptionCauseByIdOrNull(this.context, errorTraceId);
        if (result == null) {
            throw new IllegalArgumentException("Error trace not found.");
        }
        return ExceptionConverter.entityToErrorTracingDto(result);
    }
}

