/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.domain.ratelimit;

import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.easypeelsecurity.springdog.domain.ratelimit.EndpointRepository;
import org.easypeelsecurity.springdog.domain.ratelimit.RuleCache;
import org.easypeelsecurity.springdog.domain.ratelimit.VersionControlRepository;
import org.easypeelsecurity.springdog.domain.ratelimit.converter.EndpointConverter;
import org.easypeelsecurity.springdog.domain.ratelimit.converter.VersionControlConverter;
import org.easypeelsecurity.springdog.domain.ratelimit.model.Endpoint;
import org.easypeelsecurity.springdog.domain.ratelimit.model.EndpointChangelog;
import org.easypeelsecurity.springdog.shared.dto.EndpointChangelogDto;
import org.easypeelsecurity.springdog.shared.dto.EndpointDto;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class EndpointService {
    private final ObjectContext context;
    private final EndpointRepository endpointRepository;
    private final VersionControlRepository versionControlRepository;

    public EndpointService(@Qualifier(value="springdogContext") ObjectContext context, EndpointRepository endpointRepository, VersionControlRepository versionControlRepository) {
        this.context = context;
        this.endpointRepository = endpointRepository;
        this.versionControlRepository = versionControlRepository;
    }

    public EndpointDto findEndpoint(long endpointId) {
        Endpoint endpoint = this.endpointRepository.findByIdOrNull(this.context, endpointId);
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint not found");
        }
        return EndpointConverter.toDto(endpoint);
    }

    public void updateRule(EndpointDto endpointDto) {
        Endpoint endpoint = this.endpointRepository.findByIdOrNull(this.context, endpointDto.getId());
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint not found");
        }
        endpoint.updateRule(endpointDto.getRuleStatus(), endpointDto.isRuleIpBased(), endpointDto.isRulePermanentBan(), endpointDto.getRuleRequestLimitCount(), endpointDto.getRuleTimeLimitInSeconds(), endpointDto.getRuleBanTimeInSeconds(), endpointDto.getParameterNamesToEnable(), endpointDto.getHeaderNamesToEnable());
        RuleCache.changeRuleCached(endpoint.getMethodSignature(), EndpointConverter.toDto(endpoint));
        this.context.commitChanges();
    }

    public List<EndpointDto> findAllEndpoints() {
        return this.endpointRepository.findAll(this.context).stream().map(EndpointConverter::toDto).toList();
    }

    public boolean isEndpointExist(String methodSignature) {
        return this.endpointRepository.findByMethodSignatureOrNull(this.context, methodSignature) != null;
    }

    public EndpointDto getEndpointByMethodSignature(String methodSignature) {
        return EndpointConverter.toDto(this.endpointRepository.findByMethodSignatureOrNull(this.context, methodSignature));
    }

    public List<EndpointChangelogDto> getAllChangeLogsNotResolved() {
        List<EndpointChangelog> a = this.versionControlRepository.findAllChangeLogsByResolved(this.context, false);
        return VersionControlConverter.toChangelogDto(a);
    }
}

