/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.domain.ratelimit;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import java.util.List;
import org.easypeelsecurity.springdog.domain.ratelimit.EndpointVersionCompareResult;
import org.easypeelsecurity.springdog.domain.ratelimit.model.Endpoint;
import org.easypeelsecurity.springdog.domain.ratelimit.model.auto._Endpoint;
import org.easypeelsecurity.springdog.domain.ratelimit.model.auto._EndpointHeader;
import org.easypeelsecurity.springdog.domain.ratelimit.model.auto._EndpointParameter;
import org.easypeelsecurity.springdog.shared.dto.EndpointDto;
import org.easypeelsecurity.springdog.shared.dto.EndpointHeaderDto;
import org.easypeelsecurity.springdog.shared.dto.EndpointParameterDto;

public class EndpointVersionCompare {
    private static final String PROPERTY_DELIMITER = " : ";
    private static final String HASH_ALGORITHM = "SHA-256";
    private final List<EndpointDto> parsedFromController;
    private final List<Endpoint> getFromDatabase;

    public EndpointVersionCompare(List<EndpointDto> parsedFromController, List<Endpoint> getFromDatabase) {
        this.parsedFromController = parsedFromController;
        this.getFromDatabase = getFromDatabase;
    }

    public EndpointVersionCompareResult compare() {
        if (this.getFromDatabase == null || this.getFromDatabase.isEmpty()) {
            return EndpointVersionCompareResult.FIRST_RUN;
        }
        return this.generateFullHashFromDto(this.parsedFromController).equals(this.generateFullHashFromEntity(this.getFromDatabase)) ? EndpointVersionCompareResult.SAME : EndpointVersionCompareResult.DIFFERENT;
    }

    private String generateFullHashFromEntity(List<Endpoint> endpoints) {
        endpoints.sort(Comparator.comparing(_Endpoint::getPath).thenComparing(_Endpoint::getHttpMethod).thenComparing(_Endpoint::getMethodSignature));
        StringBuilder hash = new StringBuilder();
        for (Endpoint endpoint : endpoints) {
            hash.append(endpoint.getPath()).append(PROPERTY_DELIMITER).append(endpoint.getHttpMethod()).append(PROPERTY_DELIMITER).append(endpoint.getMethodSignature()).append(PROPERTY_DELIMITER);
            endpoint.getEndpointParameters().stream().sorted(Comparator.comparing(_EndpointParameter::getName).thenComparing(_EndpointParameter::getType)).forEach(p -> hash.append(p.getName()).append(PROPERTY_DELIMITER).append(p.getType()));
            endpoint.getEndpointHeaders().stream().sorted(Comparator.comparing(_EndpointHeader::getName)).forEach(p -> hash.append(p.getName()).append(PROPERTY_DELIMITER));
        }
        return this.generateSHA256Hex(hash.toString());
    }

    public String generateFullHashFromDto(List<EndpointDto> endpoints) {
        endpoints.sort(Comparator.comparing(EndpointDto::getPath).thenComparing(EndpointDto::getHttpMethod).thenComparing(EndpointDto::getMethodSignature));
        StringBuilder hash = new StringBuilder();
        for (EndpointDto endpoint : endpoints) {
            hash.append(endpoint.getPath()).append(PROPERTY_DELIMITER).append(endpoint.getHttpMethod()).append(PROPERTY_DELIMITER).append(endpoint.getMethodSignature()).append(PROPERTY_DELIMITER);
            endpoint.getParameters().stream().sorted(Comparator.comparing(EndpointParameterDto::getName).thenComparing(EndpointParameterDto::getType)).forEach(p -> hash.append(p.getName()).append(PROPERTY_DELIMITER).append(p.getType()));
            endpoint.getHeaders().stream().sorted(Comparator.comparing(EndpointHeaderDto::getName)).forEach(p -> hash.append(p.getName()).append(PROPERTY_DELIMITER));
        }
        return this.generateSHA256Hex(hash.toString());
    }

    private String generateSHA256Hex(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance(HASH_ALGORITHM);
            byte[] encoded = digest.digest(input.getBytes());
            return this.bytesToHex(encoded);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-256 algorithm not found", e);
        }
    }

    private String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

