/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.domain.ratelimit;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.easypeelsecurity.springdog.domain.ratelimit.EndpointRepository;
import org.easypeelsecurity.springdog.domain.ratelimit.EndpointVersionCompare;
import org.easypeelsecurity.springdog.domain.ratelimit.converter.EndpointConverter;
import org.easypeelsecurity.springdog.domain.ratelimit.model.Endpoint;
import org.easypeelsecurity.springdog.domain.ratelimit.model.EndpointChangelog;
import org.easypeelsecurity.springdog.domain.ratelimit.model.EndpointVersionControl;
import org.easypeelsecurity.springdog.shared.dto.EndpointDto;
import org.easypeelsecurity.springdog.shared.enums.EndpointChangeType;
import org.easypeelsecurity.springdog.shared.enums.RuleStatus;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class VersionControlService {
    private final ObjectContext context;
    private final EndpointRepository endpointRepository;

    public VersionControlService(@Qualifier(value="springdogContext") ObjectContext context, EndpointRepository endpointRepository) {
        this.context = context;
        this.endpointRepository = endpointRepository;
    }

    public void updateVersion(List<EndpointDto> parsedEndpointFromController) {
        List<Endpoint> endpointsOnDatabase = this.endpointRepository.findAll(this.context);
        EndpointVersionCompare versionCompare = new EndpointVersionCompare(parsedEndpointFromController, endpointsOnDatabase);
        String nowFullHash = versionCompare.generateFullHashFromDto(parsedEndpointFromController);
        EndpointVersionControl newVersion = (EndpointVersionControl)((Object)this.context.newObject(EndpointVersionControl.class));
        newVersion.setFullHashOfEndpoints(nowFullHash);
        switch (versionCompare.compare()) {
            case FIRST_RUN: {
                for (EndpointDto endpointDto2 : parsedEndpointFromController) {
                    Endpoint endpoint2 = EndpointConverter.toEntity(this.context, endpointDto2);
                    this.context.registerNewObject((Object)endpoint2);
                }
                break;
            }
            case SAME: {
                break;
            }
            case DIFFERENT: {
                ArrayList<Endpoint> disappearedEndpoints = new ArrayList<Endpoint>();
                ArrayList<EndpointChangelog> changelogs = new ArrayList<EndpointChangelog>();
                for (Endpoint endpoint3 : endpointsOnDatabase) {
                    if (!parsedEndpointFromController.stream().noneMatch(endpointDto -> endpointDto.getMethodSignature().equals(endpoint3.getMethodSignature()))) continue;
                    disappearedEndpoints.add(endpoint3);
                    this.context.deleteObjects((Object[])new Endpoint[]{endpoint3});
                    EndpointChangelog changelog = (EndpointChangelog)((Object)this.context.newObject(EndpointChangelog.class));
                    changelog.setReflectedVersion(newVersion);
                    if (endpoint3.getRuleStatus().equals(RuleStatus.ACTIVE.name())) {
                        changelog.setDetailString(EndpointChangeType.ENABLED_ENDPOINT_WAS_DELETED.getDescription());
                        changelog.setChangeType(EndpointChangeType.ENABLED_ENDPOINT_WAS_DELETED.name());
                    } else {
                        changelog.setDetailString(EndpointChangeType.API_DELETED.getDescription());
                        changelog.setChangeType(EndpointChangeType.API_DELETED.name());
                    }
                    changelog.setTargetMethodSignature(endpoint3.getMethodSignature());
                    changelog.setTargetPath(endpoint3.getPath());
                    changelog.setTargetMethod(endpoint3.getHttpMethod());
                    changelogs.add(changelog);
                }
                ArrayList<Endpoint> added = new ArrayList<Endpoint>();
                for (EndpointDto endpointDto3 : parsedEndpointFromController) {
                    if (!endpointsOnDatabase.stream().noneMatch(endpoint -> endpoint.getMethodSignature().equals(endpointDto3.getMethodSignature()))) continue;
                    Endpoint endpoint4 = EndpointConverter.toEntity(this.context, endpointDto3);
                    this.context.registerNewObject((Object)endpoint4);
                    added.add(endpoint4);
                    EndpointChangelog changelog = (EndpointChangelog)((Object)this.context.newObject(EndpointChangelog.class));
                    changelog.setReflectedVersion(newVersion);
                    changelog.setDetailString(EndpointChangeType.API_ADDED.getDescription());
                    changelog.setChangeType(EndpointChangeType.API_ADDED.name());
                    changelog.setTargetMethodSignature(endpoint4.getMethodSignature());
                    changelog.setTargetPath(endpoint4.getPath());
                    changelog.setTargetMethod(endpoint4.getHttpMethod());
                    changelogs.add(changelog);
                }
                for (EndpointChangelog changelog : changelogs) {
                    newVersion.addToChangelogs(changelog);
                }
                break;
            }
        }
        this.context.commitChanges();
    }
}

