/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.domain.ratelimit.converter;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cayenne.ObjectContext;
import org.easypeelsecurity.springdog.domain.ratelimit.model.Endpoint;
import org.easypeelsecurity.springdog.domain.ratelimit.model.EndpointHeader;
import org.easypeelsecurity.springdog.domain.ratelimit.model.EndpointParameter;
import org.easypeelsecurity.springdog.shared.dto.EndpointDto;
import org.easypeelsecurity.springdog.shared.dto.EndpointHeaderDto;
import org.easypeelsecurity.springdog.shared.dto.EndpointParameterDto;
import org.easypeelsecurity.springdog.shared.enums.HttpMethod;
import org.easypeelsecurity.springdog.shared.enums.RuleStatus;
import org.easypeelsecurity.springdog.shared.util.Assert;

public class EndpointConverter {
    public static Endpoint toEntity(ObjectContext context, EndpointDto endpointDto) {
        Endpoint endpoint = (Endpoint)((Object)context.newObject(Endpoint.class));
        endpoint.setPath(endpointDto.getPath());
        endpoint.setMethodSignature(endpointDto.getMethodSignature());
        endpoint.setHttpMethod(endpointDto.getHttpMethod().name());
        endpoint.setIsPatternPath(endpointDto.isPatternPath());
        endpoint.setRuleStatus(endpointDto.getRuleStatus() != null ? endpointDto.getRuleStatus().name() : RuleStatus.NOT_CONFIGURED.name());
        endpoint.setRuleIpBased(endpointDto.isRuleIpBased());
        endpoint.setRulePermanentBan(endpointDto.isRulePermanentBan());
        endpoint.setRuleRequestLimitCount(endpointDto.getRuleRequestLimitCount());
        endpoint.setRuleTimeLimitInSeconds(endpointDto.getRuleTimeLimitInSeconds());
        endpoint.setRuleBanTimeInSeconds(endpointDto.getRuleBanTimeInSeconds());
        for (EndpointParameterDto param : endpointDto.getParameters()) {
            EndpointParameter parameter = EndpointConverter.toEntity(context, param);
            parameter.setEndpoint(endpoint);
            endpoint.addToEndpointParameters(parameter);
        }
        for (EndpointHeaderDto header : endpointDto.getHeaders()) {
            EndpointHeader headerItem = EndpointConverter.toEntity(context, header);
            headerItem.setEndpoint(endpoint);
            endpoint.addToEndpointHeaders(headerItem);
        }
        return endpoint;
    }

    private static EndpointHeader toEntity(ObjectContext context, EndpointHeaderDto header) {
        EndpointHeader endpointHeader = (EndpointHeader)((Object)context.newObject(EndpointHeader.class));
        endpointHeader.setName(header.getName());
        return endpointHeader;
    }

    private static EndpointParameter toEntity(ObjectContext context, EndpointParameterDto endpointParameterDto) {
        EndpointParameter endpointParameter = (EndpointParameter)((Object)context.newObject(EndpointParameter.class));
        endpointParameter.setName(endpointParameterDto.getName());
        endpointParameter.setType(endpointParameterDto.getType());
        return endpointParameter;
    }

    public static EndpointParameterDto toDto(EndpointParameter endpointParameterEntity) {
        return new EndpointParameterDto(endpointParameterEntity.getName(), endpointParameterEntity.getType(), endpointParameterEntity.isEnabled());
    }

    private static Set<EndpointParameterDto> toDto(Set<EndpointParameter> endpointParameters) {
        return endpointParameters.stream().map(EndpointConverter::toDto).collect(Collectors.toSet());
    }

    public static EndpointDto toDto(Endpoint endpointEntity) {
        Assert.notNull((Object)((Object)endpointEntity), (String)"Endpoint must not be null");
        return EndpointDto.builder().id(endpointEntity.getId()).path(endpointEntity.getPath()).methodSignature(endpointEntity.getMethodSignature()).httpMethod(HttpMethod.valueOf((String)endpointEntity.getHttpMethod())).parameters(EndpointConverter.toParameterDto(endpointEntity.getEndpointParameters())).headers(EndpointConverter.toHeaderDto(endpointEntity.getEndpointHeaders())).isPatternPath(endpointEntity.isIsPatternPath()).ruleStatus(RuleStatus.of((String)endpointEntity.getRuleStatus())).ruleIpBased(endpointEntity.isRuleIpBased()).rulePermanentBan(endpointEntity.isRulePermanentBan()).ruleRequestLimitCount(endpointEntity.getRuleRequestLimitCount()).ruleTimeLimitInSeconds(endpointEntity.getRuleTimeLimitInSeconds()).ruleBanTimeInSeconds(endpointEntity.getRuleBanTimeInSeconds()).build();
    }

    private static Set<EndpointHeaderDto> toHeaderDto(List<EndpointHeader> endpointHeaders) {
        if (endpointHeaders == null) {
            return Set.of();
        }
        return endpointHeaders.stream().map(header -> new EndpointHeaderDto(header.getName(), header.isEnabled())).collect(Collectors.toSet());
    }

    private static Set<EndpointParameterDto> toParameterDto(List<EndpointParameter> endpointParameters) {
        if (endpointParameters == null) {
            return Set.of();
        }
        return endpointParameters.stream().map(EndpointConverter::toDto).collect(Collectors.toSet());
    }
}

