/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.domain.ratelimit.converter;

import java.util.List;
import org.easypeelsecurity.springdog.domain.ratelimit.model.EndpointChangelog;
import org.easypeelsecurity.springdog.domain.ratelimit.model.EndpointVersionControl;
import org.easypeelsecurity.springdog.shared.dto.EndpointChangelogDto;
import org.easypeelsecurity.springdog.shared.dto.VersionControlDto;
import org.easypeelsecurity.springdog.shared.enums.EndpointChangeType;

public abstract class VersionControlConverter {
    public static VersionControlDto toVersionControlDto(EndpointVersionControl versionControl) {
        return VersionControlDto.builder().id(Long.valueOf(versionControl.getId())).fullHashOfEndpoints(versionControl.getFullHashOfEndpoints()).dateOfVersion(versionControl.getDateOfVersion()).changelogs(VersionControlConverter.toChangelogDto(versionControl.getChangelogs())).build();
    }

    public static List<VersionControlDto> toVersionControlDto(List<EndpointVersionControl> versionControls) {
        return versionControls.stream().map(VersionControlConverter::toVersionControlDto).toList();
    }

    public static EndpointChangelogDto toChangelogDto(EndpointChangelog changelog) {
        return EndpointChangelogDto.builder().id(Long.valueOf(changelog.getId())).changeType(EndpointChangeType.valueOf((String)changelog.getChangeType())).detailString(changelog.getDetailString()).isResolved(changelog.isIsResolved()).targetMethod(changelog.getTargetMethod()).targetMethodSignature(changelog.getTargetMethodSignature()).targetPath(changelog.getTargetPath()).build();
    }

    public static List<EndpointChangelogDto> toChangelogDto(List<EndpointChangelog> changelogs) {
        return changelogs.stream().map(VersionControlConverter::toChangelogDto).toList();
    }

    public static EndpointVersionControl toVersionControl(VersionControlDto dto) {
        EndpointVersionControl versionControl = new EndpointVersionControl();
        versionControl.setDateOfVersion(dto.getDateOfVersion());
        versionControl.setFullHashOfEndpoints(dto.getFullHashOfEndpoints());
        versionControl.setId(dto.getId());
        for (EndpointChangelogDto changelog : dto.getChangelogs()) {
            versionControl.addToChangelogs(VersionControlConverter.toEndpointChangelog(changelog));
        }
        return versionControl;
    }

    private static EndpointChangelog toEndpointChangelog(EndpointChangelogDto changelog) {
        EndpointChangelog endpointChangelog = new EndpointChangelog();
        endpointChangelog.setChangeType(changelog.getChangeType().name());
        endpointChangelog.setDetailString(changelog.getDetailString());
        endpointChangelog.setId(changelog.getId());
        endpointChangelog.setIsResolved(changelog.isResolved());
        endpointChangelog.setTargetMethod(changelog.getTargetMethod());
        endpointChangelog.setTargetMethodSignature(changelog.getTargetMethodSignature());
        endpointChangelog.setTargetPath(changelog.getTargetPath());
        endpointChangelog.setReflectedVersion(VersionControlConverter.toVersionControl(changelog.getReflectedVersion()));
        return endpointChangelog;
    }
}

