/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.domain.ratelimit.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.easypeelsecurity.springdog.domain.ratelimit.model.EndpointHeader;
import org.easypeelsecurity.springdog.domain.ratelimit.model.EndpointParameter;
import org.easypeelsecurity.springdog.domain.ratelimit.model.auto._Endpoint;
import org.easypeelsecurity.springdog.shared.enums.RuleStatus;
import org.easypeelsecurity.springdog.shared.util.Assert;

public class Endpoint
extends _Endpoint {
    private static final long serialVersionUID = 1L;

    public Endpoint() {
        this.setRuleStatus(RuleStatus.NOT_CONFIGURED.name());
        this.setRuleRequestLimitCount(0);
        this.setRuleTimeLimitInSeconds(0);
        this.setRuleBanTimeInSeconds(0);
        this.setRulePermanentBan(false);
        this.setRuleIpBased(false);
        this.endpointParameters = new ArrayList();
        this.endpointHeaders = new ArrayList();
    }

    @Override
    public void addToEndpointParameters(EndpointParameter obj) {
        Assert.notNull((Object)((Object)obj), (String)"EndpointParameter must not be null");
        obj.setEndpoint(this);
        super.addToEndpointParameters(obj);
    }

    @Override
    public void removeFromEndpointParameters(EndpointParameter obj) {
        Assert.notNull((Object)((Object)obj), (String)"EndpointParameter must not be null");
        super.removeFromEndpointParameters(obj);
    }

    @Override
    public void addToEndpointHeaders(EndpointHeader obj) {
        Assert.notNull((Object)((Object)obj), (String)"EndpointHeader must not be null");
        obj.setEndpoint(this);
        super.addToEndpointHeaders(obj);
    }

    @Override
    public void removeFromEndpointHeaders(EndpointHeader obj) {
        Assert.notNull((Object)((Object)obj), (String)"EndpointHeader must not be null");
        super.removeFromEndpointHeaders(obj);
    }

    public void updateRule(RuleStatus ruleStatus, boolean ruleIpBased, boolean rulePermanentBan, int ruleRequestLimitCount, int ruleTimeLimitInSeconds, int ruleBanTimeInSeconds, Set<String> enableParamNames, Set<String> enableHeaderNames) {
        Assert.isNotEqual((Object)ruleStatus, (Object)RuleStatus.NOT_CONFIGURED, (String)"Couldn't change ruleStatus to NOT_CONFIGURED");
        Assert.isTrue((enableParamNames != null ? 1 : 0) != 0, (String)"enableParamNames must not be null");
        Assert.isTrue((enableHeaderNames != null ? 1 : 0) != 0, (String)"enableHeaderNames must not be null");
        this.ruleValidate(ruleStatus.name(), ruleIpBased, rulePermanentBan, ruleRequestLimitCount, ruleTimeLimitInSeconds, ruleBanTimeInSeconds, enableParamNames, enableHeaderNames, this.getEndpointParameters(), this.getEndpointHeaders());
        this.setRuleStatus(ruleStatus.name());
        this.setRuleIpBased(ruleIpBased);
        this.setRulePermanentBan(rulePermanentBan);
        this.setRuleRequestLimitCount(ruleRequestLimitCount);
        this.setRuleTimeLimitInSeconds(ruleTimeLimitInSeconds);
        this.setRuleBanTimeInSeconds(ruleBanTimeInSeconds);
        this.getEndpointParameters().forEach(param -> param.setEnabled(enableParamNames.contains(param.getName())));
        this.getEndpointHeaders().forEach(header -> header.setEnabled(enableHeaderNames.contains(header.getName())));
    }

    private void ruleValidate(String ruleStatus, boolean ruleIpBased, boolean rulePermanentBan, int ruleRequestLimitCount, int ruleTimeLimitInSeconds, int ruleBanTimeInSeconds, Set<String> enableParamNames, Set<String> enableHeaderNames, List<EndpointParameter> endpointParameters, List<EndpointHeader> endpointHeaders) {
        if (RuleStatus.ACTIVE.name().equals(ruleStatus)) {
            if (ruleRequestLimitCount <= 0) {
                throw new IllegalArgumentException("Request limit count must be greater than 0");
            }
            if (ruleTimeLimitInSeconds <= 0) {
                throw new IllegalArgumentException("Time limit must be greater than 0");
            }
            if (ruleBanTimeInSeconds <= 0 && !rulePermanentBan) {
                throw new IllegalArgumentException("Ban time must be greater than 0");
            }
            if (!ruleIpBased && Endpoint.isParamNotActivated(enableParamNames, endpointParameters) && Endpoint.isHeaderNotActivated(enableHeaderNames, endpointHeaders)) {
                throw new IllegalArgumentException("At least one combination must be enabled");
            }
        }
    }

    private static boolean isHeaderNotActivated(Set<String> enableHeaderNames, List<EndpointHeader> endpointHeaders) {
        return endpointHeaders.stream().filter(header -> enableHeaderNames.contains(header.getName())).count() == 0L;
    }

    private static boolean isParamNotActivated(Set<String> enableParamNames, List<EndpointParameter> endpointParameters) {
        return endpointParameters.stream().filter(param -> enableParamNames.contains(param.getName())).count() == 0L;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Endpoint endpoint = (Endpoint)((Object)obj);
        return Objects.equals(this.path, endpoint.path) && Objects.equals(this.isPatternPath, endpoint.isPatternPath) && Objects.equals(this.httpMethod, endpoint.httpMethod);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.isPatternPath, this.httpMethod);
    }
}

