/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.domain.statistics.model;

import java.time.LocalDate;
import org.easypeelsecurity.springdog.domain.statistics.model.auto._EndpointMetric;

public class EndpointMetric
extends _EndpointMetric {
    private static final long serialVersionUID = 1L;

    public void updateStatistics(long additionalPageView, long additionalResponseTimeSum, long ratelimitFailureCount) {
        long totalPageView = this.getPageView() + additionalPageView;
        long existResponseTime = this.getPageView() * this.getAverageResponseMs();
        long totalResponseTime = existResponseTime + additionalResponseTimeSum;
        int averageResponseTime = (int)(totalResponseTime / totalPageView);
        this.setPageView(totalPageView);
        this.setAverageResponseMs(averageResponseTime);
        this.setFailureWithRatelimit(this.getFailureWithRatelimit() + ratelimitFailureCount);
    }

    @Override
    public void setAverageResponseMs(long averageResponseMs) {
        if (averageResponseMs < 0L) {
            throw new IllegalArgumentException("average response time must be a positive number");
        }
        super.setAverageResponseMs(averageResponseMs);
    }

    @Override
    public void setPageView(long pageView) {
        if (pageView < 0L) {
            throw new IllegalArgumentException("page view must be a positive number");
        }
        super.setPageView(pageView);
    }

    @Override
    public void setMetricDate(LocalDate metricDate) {
        if (metricDate == null) {
            throw new IllegalArgumentException("metric date cannot be null");
        }
        super.setMetricDate(metricDate);
    }

    @Override
    public void setFailureWithRatelimit(long ratelimitFailureCount) {
        if (ratelimitFailureCount < 0L) {
            throw new IllegalArgumentException("ratelimit failure count must be a positive number");
        }
        super.setFailureWithRatelimit(ratelimitFailureCount);
    }
}

