/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.manager.config;

import org.easypeelsecurity.springdog.domain.ratelimit.EndpointService;
import org.easypeelsecurity.springdog.manager.agent.AgentExternalAccessInterceptor;
import org.easypeelsecurity.springdog.manager.ratelimit.RatelimitInterceptor;
import org.easypeelsecurity.springdog.manager.statistics.RequestTimingInterceptor;
import org.easypeelsecurity.springdog.notification.SlowResponseEmailNotificationManager;
import org.easypeelsecurity.springdog.shared.configuration.SpringdogProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class SpringdogHandlerInterceptorApplier
implements WebMvcConfigurer {
    private final EndpointService endpointService;
    private final SpringdogProperties springdogProperties;
    private final SlowResponseEmailNotificationManager slowResponseEmailNotificationManager;

    public SpringdogHandlerInterceptorApplier(EndpointService endpointService, SpringdogProperties springdogProperties, SlowResponseEmailNotificationManager slowResponseEmailNotificationManager) {
        this.endpointService = endpointService;
        this.springdogProperties = springdogProperties;
        this.slowResponseEmailNotificationManager = slowResponseEmailNotificationManager;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new RatelimitInterceptor(this.endpointService));
        registry.addInterceptor((HandlerInterceptor)new AgentExternalAccessInterceptor(this.springdogProperties));
        registry.addInterceptor((HandlerInterceptor)new RequestTimingInterceptor(this.slowResponseEmailNotificationManager));
    }
}

