/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.manager.ratelimit;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class MultipleReadHttpServletRequest
extends HttpServletRequestWrapper {
    private ByteArrayOutputStream cachedBytes;
    private Map<String, String[]> parameterMap;

    public MultipleReadHttpServletRequest(HttpServletRequest request) {
        super(request);
        this.cacheParameterMap(request);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.cachedBytes == null) {
            this.cacheInputStream();
        }
        return new CachedServletInputStream(this.cachedBytes.toByteArray());
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public String getParameter(String name) {
        if (this.parameterMap.containsKey(name)) {
            return this.parameterMap.get(name)[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public String[] getParameterValues(String name) {
        return this.parameterMap.get(name);
    }

    private void cacheInputStream() throws IOException {
        this.cachedBytes = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)super.getInputStream(), (OutputStream)this.cachedBytes);
    }

    private void cacheParameterMap(HttpServletRequest request) {
        this.parameterMap = request.getParameterMap();
    }

    private static class CachedServletInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream buffer;

        CachedServletInputStream(byte[] contents) {
            this.buffer = new ByteArrayInputStream(contents);
        }

        public int read() {
            return this.buffer.read();
        }

        public boolean isFinished() {
            return this.buffer.available() == 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            throw new UnsupportedOperationException();
        }
    }
}

