/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.manager.statistics;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.easypeelsecurity.springdog.manager.statistics.EndpointMetricCached;

public abstract class EndpointMetricCacheManager {
    private static final Cache<String, EndpointMetricCachedValue> CACHE_INSTANCE = Caffeine.newBuilder().build();

    public static void addResponseTime(String methodSignature, long responseTime) {
        ((EndpointMetricCachedValue)CACHE_INSTANCE.get((Object)methodSignature, k -> new EndpointMetricCachedValue())).addResponseTime(responseTime);
    }

    public static void incrementFailureCount(String methodSignature) {
        ((EndpointMetricCachedValue)CACHE_INSTANCE.get((Object)methodSignature, k -> new EndpointMetricCachedValue())).incrementFailureCount();
    }

    public static List<EndpointMetricCached> getAllData() {
        ArrayList<EndpointMetricCached> result = new ArrayList<EndpointMetricCached>();
        for (Map.Entry entry : CACHE_INSTANCE.asMap().entrySet()) {
            EndpointMetricCachedValue value = (EndpointMetricCachedValue)entry.getValue();
            result.add(new EndpointMetricCached((String)entry.getKey(), value.getResponseTimes().stream().mapToLong(Long::longValue).toArray(), value.getFailureCount()));
        }
        return result;
    }

    public static void invalidateByMethodSignature(String methodSignature) {
        CACHE_INSTANCE.invalidate((Object)methodSignature);
    }

    public static void clear() {
        CACHE_INSTANCE.invalidateAll();
    }

    static class EndpointMetricCachedValue {
        private final ArrayList<Long> responseTimes = new ArrayList();
        private int failureCount;

        EndpointMetricCachedValue() {
        }

        public synchronized void addResponseTime(long responseTime) {
            this.responseTimes.add(responseTime);
        }

        public synchronized void incrementFailureCount() {
            ++this.failureCount;
        }

        public List<Long> getResponseTimes() {
            return this.responseTimes;
        }

        public int getFailureCount() {
            return this.failureCount;
        }
    }
}

