/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.manager.statistics;

import java.time.LocalDate;
import java.util.List;
import org.easypeelsecurity.springdog.domain.statistics.StatisticsService;
import org.easypeelsecurity.springdog.manager.statistics.EndpointMetricCacheManager;
import org.easypeelsecurity.springdog.manager.statistics.EndpointMetricCached;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class EndpointMetricScheduler {
    private final StatisticsService statisticsService;

    public EndpointMetricScheduler(StatisticsService statisticsService) {
        this.statisticsService = statisticsService;
    }

    @Scheduled(fixedRateString="${springdog.endpointMetricScheduler.fixedRate:10000}")
    public void saveEndpointStatistics() {
        List<EndpointMetricCached> cached = EndpointMetricCacheManager.getAllData();
        for (EndpointMetricCached entry : cached) {
            this.statisticsService.upsertEndpointMetrics(entry.methodSignature(), entry.responseTimes(), (long)entry.ratelimitFailureCount(), LocalDate.now());
            EndpointMetricCacheManager.invalidateByMethodSignature(entry.methodSignature());
        }
    }
}

