/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.manager.statistics;

import org.easypeelsecurity.springdog.domain.statistics.StatisticsService;
import org.easypeelsecurity.springdog.manager.statistics.SystemUsageMonitor;
import org.easypeelsecurity.springdog.notification.SystemWatchNotificationManager;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class SystemMetricsScheduler {
    private final StatisticsService statisticsService;
    private final SystemWatchNotificationManager systemWatchNotificationManager;

    public SystemMetricsScheduler(StatisticsService statisticsService, SystemWatchNotificationManager systemWatchNotificationManager) {
        this.statisticsService = statisticsService;
        this.systemWatchNotificationManager = systemWatchNotificationManager;
    }

    @Scheduled(fixedRateString="${springdog.systemMetricsScheduler.fixedRate:60000}")
    public void storeSystemsMetrics() {
        SystemUsageMonitor systemUsageMonitor = new SystemUsageMonitor();
        double cpuUsagePercent = systemUsageMonitor.systemCpuUsagePercent();
        double memoryUsagePercent = systemUsageMonitor.getSystemMemoryUsagePercent();
        double diskUsagePercent = systemUsageMonitor.diskUsagePercent();
        double jvmHeapUsagePercent = systemUsageMonitor.getJvmHeapUsagePercent();
        double jvmNonHeapUsagePercent = systemUsageMonitor.getJvmNonHeapUsagePercent();
        long jvmTotalMemoryUsed = systemUsageMonitor.getJvmTotalMemoryUsed();
        long networkInBytes = systemUsageMonitor.getNetworkInBytes();
        long networkOutBytes = systemUsageMonitor.getNetworkOutBytes();
        this.statisticsService.storeSystemMetrics(cpuUsagePercent, memoryUsagePercent, diskUsagePercent, jvmHeapUsagePercent, jvmNonHeapUsagePercent, jvmTotalMemoryUsed, networkInBytes, networkOutBytes);
        this.systemWatchNotificationManager.checkMetrics(cpuUsagePercent, memoryUsagePercent, diskUsagePercent);
    }
}

