/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.notification;

import java.util.HashMap;
import java.util.Map;
import org.easypeelsecurity.springdog.notification.email.MetricContext;
import org.easypeelsecurity.springdog.notification.email.SlowResponseEmailNotification;
import org.easypeelsecurity.springdog.shared.settings.NotificationGlobalSetting;
import org.easypeelsecurity.springdog.shared.settings.SlowResponseSetting;
import org.easypeelsecurity.springdog.shared.settings.SpringdogSettingManager;
import org.easypeelsecurity.springdog.shared.settings.SpringdogSettings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SlowResponseEmailNotificationManager {
    private final Map<String, MetricContext<String, Long>> metricContexts;
    private final SpringdogSettingManager settings;
    private final SlowResponseEmailNotification emailNotification;

    public SlowResponseEmailNotificationManager(SpringdogSettingManager settings, SlowResponseEmailNotification emailNotification, Map<String, MetricContext<String, Long>> metricContexts) {
        this.settings = settings;
        this.emailNotification = emailNotification;
        this.metricContexts = metricContexts != null ? metricContexts : new HashMap();
    }

    @Autowired
    public SlowResponseEmailNotificationManager(SpringdogSettingManager settings, SlowResponseEmailNotification emailNotification) {
        this(settings, emailNotification, new HashMap<String, MetricContext<String, Long>>());
    }

    public void checkSlowResponse(SlowResponse value) {
        SpringdogSettings springdogSettings = this.settings.getSettings();
        SlowResponseSetting slowResponseSetting = springdogSettings.getSlowResponseSetting();
        NotificationGlobalSetting notificationGlobalSetting = springdogSettings.getNotificationGlobalSetting();
        if (!notificationGlobalSetting.isEnabled() || !slowResponseSetting.isEnabled()) {
            return;
        }
        String metricName = "[%s] %s".formatted(value.endpointMethod, value.endpointPath);
        MetricContext context = this.metricContexts.computeIfAbsent(metricName, n -> new MetricContext<String, Long>((String)n, this.emailNotification));
        context.checkMetric(value.currentResponseTime, slowResponseSetting.getResponseTimeMs());
    }

    public record SlowResponse(String endpointPath, String endpointMethod, long currentResponseTime) implements Comparable<SlowResponse>
    {
        @Override
        public int compareTo(SlowResponse o) {
            return Long.compare(this.currentResponseTime, o.currentResponseTime);
        }
    }
}

