/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.notification;

import java.util.HashMap;
import java.util.Map;
import org.easypeelsecurity.springdog.notification.email.MetricContext;
import org.easypeelsecurity.springdog.notification.email.SystemWatchEmailNotification;
import org.easypeelsecurity.springdog.shared.settings.NotificationGlobalSetting;
import org.easypeelsecurity.springdog.shared.settings.SpringdogSettingManager;
import org.easypeelsecurity.springdog.shared.settings.SpringdogSettings;
import org.easypeelsecurity.springdog.shared.settings.SystemWatchSetting;
import org.springframework.stereotype.Service;

@Service
public class SystemWatchNotificationManager {
    private final Map<String, MetricContext<String, Double>> metricContexts;
    private final SpringdogSettingManager settingManager;
    private final SystemWatchEmailNotification emailNotification;

    public SystemWatchNotificationManager(SpringdogSettingManager settingManager, SystemWatchEmailNotification emailNotification) {
        this.settingManager = settingManager;
        this.emailNotification = emailNotification;
        this.metricContexts = new HashMap<String, MetricContext<String, Double>>();
        this.initializeMetricContexts();
    }

    protected void initializeMetricContexts() {
        this.metricContexts.put("CPU", new MetricContext<String, Double>("CPU", this.emailNotification));
        this.metricContexts.put("Memory", new MetricContext<String, Double>("Memory", this.emailNotification));
        this.metricContexts.put("Disk", new MetricContext<String, Double>("Disk", this.emailNotification));
    }

    public void checkMetrics(double cpuUsage, double memoryUsage, double diskUsage) {
        SpringdogSettings springdogSettings = this.settingManager.getSettings();
        SystemWatchSetting systemWatchSetting = springdogSettings.getSystemWatchSetting();
        NotificationGlobalSetting notificationGlobalSetting = springdogSettings.getNotificationGlobalSetting();
        if (!systemWatchSetting.isEnabled() || !notificationGlobalSetting.isEnabled()) {
            return;
        }
        this.metricContexts.get("CPU").checkMetric(cpuUsage, systemWatchSetting.getCpuThreshold());
        this.metricContexts.get("Memory").checkMetric(memoryUsage, systemWatchSetting.getMemoryThreshold());
        this.metricContexts.get("Disk").checkMetric(diskUsage, systemWatchSetting.getDiskThreshold());
    }
}

